#ifndef MARS_MGeomCam
#define MARS_MGeomCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MGeomPix;

class MGeomCam : public MParContainer
{
private:
    UInt_t   fNumPixels;  // Number of pixels in this camera
    Float_t  fMaxRadius;  // maximum radius of the camera (eg. for GUI layout)

    Float_t  fCamDist;    // [m] Average distance of the camera from the mirror
    Float_t  fConvMm2Deg; // conversion factor to convert mm in the camera plain into degrees

    TObjArray *fPixels;   // Array of singel pixels storing the geometry

protected:
    void CalcMaxRadius();
    void InitOuterRing();

public:
    MGeomCam(UInt_t npix, Float_t dist, const char *name=NULL, const char *title=NULL);
    virtual ~MGeomCam();

    virtual TObject *Clone(const char *newname=NULL) const;

    Float_t GetCameraDist() const      { return fCamDist; }
    Float_t GetConvMm2Deg() const      { return fConvMm2Deg; }

    UInt_t  GetNumPixels() const       { return fNumPixels; }
    Float_t GetMaxRadius() const       { return fMaxRadius; }
    Float_t GetPixRatio(UInt_t i) const;

    MGeomPix &operator[](Int_t i)       { return *(MGeomPix*)fPixels->UncheckedAt(i); }
    MGeomPix &operator[](Int_t i) const { return *(MGeomPix*)fPixels->UncheckedAt(i); }



    virtual void Print(Option_t *opt=NULL) const;

    ClassDef(MGeomCam, 1)  // Geometry base class for the camera
};

#endif

