#ifndef MARS_MRawEvtHeader
#define MARS_MRawEvtHeader

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class ifstream;
class MTime;
class MArrayB;
class MRawRunHeader;

//
// Trigger Type (TT)
//
enum {
    kTTEvent       = 0,
    kTTPedestal    = 1,
    kTTCalibration = 2
};

class MRawEvtHeader : public MParContainer
{
private:
    MTime   *fTime;            //! object to store the time in (ReadEvt)

    UInt_t   fDAQEvtNumber;    // Number of Event

    UInt_t   fNumTrigLvl1;     // Number of 1st level tiggers between 2 events
    UInt_t   fNumTrigLvl2;     // Number of 2nd level tiggers between 2 events
    UInt_t   fTrigPattern[2];  // Trigger configuration

    UShort_t fNumLoGainOn;     // Indicating if no pixel has a neglegible
                               // low gain signal (0), else it is the number
                               // of pixels with lo gain on

    //
    // Informations only needed to read the raw file correctly
    //
    UShort_t fTrigType;        //! Trigger Type of this event
    MArrayB *fPixLoGainOn;     //! Array which tell you which pixels have lo gain on

public:

    MRawEvtHeader(const char *name=NULL, const char *title=NULL);
    ~MRawEvtHeader();

    void Init(MRawRunHeader *rh, MTime *t);

    void Clear(Option_t * = NULL);
    void Print(Option_t * = NULL) const;

    void FillHeader(UInt_t, Float_t=0);

    UShort_t GetTrigType() const { return fTrigType; }
    UInt_t GetDAQEvtNumber() const { return fDAQEvtNumber; }

    int ReadEvt(istream& fin);

    ClassDef(MRawEvtHeader, 1) // Parameter Conatiner for raw EVENT HEADER
}; 

#endif
