#ifndef MARS_MFCT1SelBasic
#define MARS_MFCT1SelBasic

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFCT1SelBasic                                                           //
//                                                                         //
// Class to evaluate basic cuts                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MMcEvt;
class MGeomCam;
class MCerPhotEvt;
class MPedestalCam;
//class MRawRunHeader;

class MFCT1SelBasic : public MFilter
{
private:
    const MMcEvt        *fMcEvt;       
    const MGeomCam      *fCam;      // Camera Geometry 
    const MCerPhotEvt   *fEvt;      // Cerenkov Photon Event 
    //const MPedestalCam  *fPed;      // Pedestal information
    //const MRawRunHeader *fRawRun;

    Float_t     fMinPhotons;
    Float_t     fThetaMin;
    Float_t     fThetaMax;

    Int_t       fCut[4];

    Bool_t      fResult;

    Int_t Set(Int_t rc);

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    Bool_t IsExpressionTrue() const { return fResult; }

    Bool_t SwTrigger();

public:
    MFCT1SelBasic(const char *name=NULL, const char *title=NULL);

    void SetCuts(Float_t minphotons, Float_t thetamin, Float_t thetamax);

    ClassDef(MFCT1SelBasic, 0)   // Class to evaluate basic cuts
};

#endif











