#ifndef MARS_MObservatoryLocation
#define MARS_MObservatoryLocation

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MObservatoryLocation : public MParContainer
{
private:
  TString  fObsName;
  Double_t fLatitude;
  Double_t fLongitude;
  Double_t fElevation;
  static Double_t fgDegToRad;
  //  TH1F     fHorizon;

  void Init(const char *name, const char *title);

public:
    enum LocationName_t
    {
        kMagic1,
        kMagic2,
        kRobertGarten
    };

  MObservatoryLocation(const char *name=NULL, const char *title=NULL);
  MObservatoryLocation(LocationName_t name, const char *name=NULL, const char *title=NULL);
  ~MObservatoryLocation();

  void SetLatitude(Double_t latitude)   { fLatitude = latitude; }
  void SetLongitude(Double_t longitude) { fLongitude = longitude; }
  void SetElevation(Double_t elevation) { fElevation = elevation; }
  void SetObservatoryName(TString name) { fObsName = name; }
  
  void Print(Option_t *) const;
  
  Double_t GetLatitude() const        { return fLatitude*kRad2Deg; }
  Double_t GetLongitude() const       { return fLongitude*kRad2Deg; }
  Double_t GetElevation() const       { return fElevation; }
  Double_t GetLatitudeRad() const     { return fLatitude; }
  Double_t GetLongitudeRad() const    { return fLongitude; }
  TString  GetObservatoryName() const { return fObsName; }
  // Double_t GetHorizon(Double_t phi);
  // void SetHorizonLine(TF1 hor) { fHorizon = hor; }
  // TH1F GetHorizonLine() { return fHorizon; }
  
  ClassDef(MObservatoryLocation, 1)

};

#endif

