#ifndef MARS_MFEventSelector
#define MARS_MFEventSelector

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFEventSelector                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;

class MFEventSelector : public MFilter
{
private:
    Int_t   fNumTotalEvts;
    Int_t   fNumSelectEvts;
    Float_t fSelRatio;

    Int_t   fNumSelectedEvts; //!

    Bool_t  fResult;

    void StreamPrimitive(ofstream &out) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    enum { kNumTotalFromFile = BIT(14) };

    Int_t fErrors[2];

public:
    MFEventSelector(const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }

    void SetNumTotalEvts(Int_t n) { fNumTotalEvts = n; ResetBit(kNumTotalFromFile); }
    void SetNumSelectEvts(Int_t n) { fNumSelectEvts = n; }
    void SetSelectionRatio(Float_t f) { fSelRatio = f; }

    ClassDef(MFEventSelector, 0) // A Filter to select events from files
};

#endif
