#ifndef MARS_M2dimFunctionFit
#define MARS_M2dimFunctionFit

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHillas;
class MNewImagePar;
class MSrcPosCam;
class MGeomCam;
class MCerPhotEvt;

class M2dimFunctionFit : public MTask
{
private:
    MGeomCam    *fGeomCam;
    MCerPhotEvt *fCerPhotEvt;

    MHillas      *fHillas;       //! Pointer to the source independent hillas parameters
    MSrcPosCam   *fSrcPos;       //! Pointer to the source position
    MNewImagePar *fNewImagePar;  //! Pointer to the output container for the new image parameters

    TString fSrcName;
    TString fNewParName;
    TString fHillasInput;

    Int_t  fErrors;

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();
    Bool_t PostProcess();

public:
    M2dimFunctionFit(const char *twodimfunname,
                     const char *name=NULL, const char *title=NULL);

    void SetInput(TString hilname) { fHillasInput = hilname; }

    ClassDef(M2dimFunctionFit, 0) // task to fit a 2-dim function to the shower image
};

#endif









