/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Wolfgang Wittek 10/2003 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
// M2dimFunctionFit
//
// Task to fit a 2-dim function to the shower image
//
//////////////////////////////////////////////////////////////////////////////
#include "M2dimFunctionFit.h"

#include <fstream.h>

#include "MParList.h"

#include "MGeomCam.h"
#include "MSrcPosCam.h"
#include "MCerPhotEvt.h"
#include "MNewImagePar.h"
#include "MNewImagePar.h"
#include "MLog.h"
#include "MLogManip.h"

ClassImp(M2dimFunctionFit);

static const TString gsDefName  = "M2dimFunctionFit";
static const TString gsDefTitle = "Fit 2-dim function";

// -------------------------------------------------------------------------
//
// Default constructor.
//
// twodimfunname is the name of a container of type M2dimFunction, 
// in which the parameters are stored; the default is "M2dimFunction"
//
//
M2dimFunctionFit::M2dimFunctionFit(const char *twodimfunname,
                                   const char *name, const char *title)
{
    fName  = name  ? name  : gsDefName.Data();
    fTitle = title ? title : gsDefTitle.Data();

    f2dimFunName  = twodimfunname;
    fHillasInput = "MHillas";
}

// -------------------------------------------------------------------------
//
Int_t M2dimFunctionFit::PreProcess(MParList *pList)
{
    fHillas = (MHillas*)pList->FindObject(fHillasInput, "MHillas");
    if (!fHillas)
    {
        *fLog << err << dbginf << "MHillas not found... aborting." << endl;
        return kFALSE;
    }


    fCerPhotEvt = (MCerPhotEvt*)pList->FindObject("MCerPhotEvt");
    if (!fCerPhotEvt)
    {
        *fLog << dbginf << "MCerPhotEvt not found... aborting." << endl;
        return kFALSE;
    }

    fGeomCam = (MGeomCam*)pList->FindObject("MGeomCam");
    if (!fGeomCam)
    {
        *fLog << dbginf << "MGeomCam (Camera Geometry) missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    f2dimfun = (M2dimFunction*)pList->FindCreateObj("M2dimFunction", f2dimFunName);
    if (!f2dimfun)
    {
      *fLog << dbginf << "M2dimFunction object '" << f2dimFunName 
            << "' not found... aborting." << endl;
      return kFALSE;
    }

    fErrors = 0;

    return kTRUE;
}

// -------------------------------------------------------------------------
//
// fit 2-dim function to the shower image
//

Int_t M2dimFunctionFit::Process()
{
  Bool_t rc = f2dimfun->Fit();
  if (!rc)
  {
      fErrors++;
      return kCONTINUE;
  }

  return kTRUE;
}

// --------------------------------------------------------------------------
//
//  Prints some statistics about the hillas calculation. The percentage
//  is calculated with respect to the number of executions of this task.
//
/*
Bool_t M2dimFunctionFit::PostProcess()
{
    if (GetNumExecutions()==0)
        return kTRUE;

    *fLog << inf << endl;
    *fLog << GetDescriptor() << " execution statistics:" << endl;
    *fLog << dec << setfill(' ');
    *fLog << " " << fErrors << " (" << (int)(fErrors*100/GetNumExecutions()) << "%) Evts skipped due to: fit of 2-dim function failed" << endl;
    *fLog << endl;

    return kTRUE;
}
*/

