#ifndef MARS_MRawCrateData
#define MARS_MRawCrateData

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

//gcc 3.2
//class ifstream;
#include <iosfwd>

class MRawCrateData : public MParContainer
{
private:
    UShort_t fDAQCrateNumber;  // Crate number the information corresponds to
    UInt_t   fFADCEvtNumber;   // event number from the fadc
    UInt_t   fFADCClockTick;   // clock tick from the fadc (20MHz)

public:
    MRawCrateData();

    UChar_t GetDAQCrateNumber() const  { return fDAQCrateNumber; }
    UInt_t  GetFADCEvtNumber() const   { return fFADCEvtNumber;  }
    UInt_t  GetFADCClockTick() const   { return fFADCClockTick;  }

    void Print(Option_t *t=NULL) const;

    void ReadEvt(istream& fin);

    ClassDef(MRawCrateData, 1) //Container to store the Raw CRATE DATA
};

#endif
