#include <TApplication.h>

#include "MAGIC.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MMars.h"
#include "MArray.h"
#include "MParContainer.h"

#ifdef HAVE_XPM
#include "MLogo.h"
#endif

using namespace std;
/*
#if ROOT_VERSION_CODE < ROOT_VERSION(3,10,02)
#include <TRootGuiFactory.h>
#include <TPluginManager.h>
void InitGuiFactory()
{
    if (gROOT->IsBatch())
        gROOT->SetBatch(kFALSE);

    //
    // Must be loaded by hand, because it is not loaded by TGApplication.
    // We could also use TApplication instead, but TApplication doesn't
    // deal with the DISPLAY variable in a convient way.
    //
    TPluginHandler *h;
    if ((h = gROOT->GetPluginManager()->FindHandler("TGuiFactory", "root")))
    {
        if (h->LoadPlugin() == -1)
            return;
        gGuiFactory = (TGuiFactory*)h->ExecPlugin(0);
    }
}
#endif
*/

// **********************************************************************
//
//    MARS main program  
//
//    The only job of the main program is the initialisation of ROOT and 
//    the start of the guiinterface for the mars program
//
//    started by  h. kornmayer      january, 3rd  2001 
static void StartUpMessage()
{
    gLog << all << endl;

    //                1         2         3         4         5
    //       12345678901234567890123456789012345678901234567890
    gLog << "==================================================" << endl;
    gLog << "                    MARS V" << MARSVER              << endl;
    gLog << "    Magic Analysis and Reconstruction Software"     << endl;
    gLog << "            Compiled on <" << __DATE__ << ">"       << endl;
    gLog << "               Using ROOT v" << ROOTVER             << endl;
    gLog << "==================================================" << endl;
    gLog << endl;
}

static void Usage()
{
    gLog << all << endl;
    gLog << "Sorry the usage is:" << endl;
    gLog << "   mars [-v#]" << endl << endl;
    gLog << "     -v0: verbosity level: as less as possible" << endl;
    gLog << "     -v1: errors only"                          << endl;
    gLog << "     -v2: errors and warnings <default>"        << endl;
    gLog << "     -v3: errors, warnings and infos"           << endl;
}

int main(int argc, char **argv)
{
    StartUpMessage();

    //
    // check for the right usage of the program
    //
    if (argc<1 || argc>2)
    {
        Usage();
        return -1;
    }

    if (argc==2)
    {
        if (argv[1][0]!='-' || argv[1][1]!='v')
        {
            Usage();
            return -1;
        }

        switch (argv[1][2])
        {
        case '0':
            gLog.SetDebugLevel(0);
            break;
        case '1':
            gLog.SetDebugLevel(1);
            break;
        case '2':
            gLog.SetDebugLevel(2);
            break;
        case '3':
            gLog.SetDebugLevel(3);
            break;
        default:
            Usage();
            return -1;
        }
    }
    else
        gLog.SetDebugLevel(2);

#ifdef HAVE_XPM
    MLogo logo;
    logo.Popup();
#endif

    //
    // initialise ROOT
    //
    TApplication app("Mars", &argc, argv);
    if (gROOT->IsBatch() || !gClient)
    {
        gLog << "Bombing... maybe your DISPLAY variable is not set correctly!" << endl;
        return 1;
    }

    //
    // Swtich of TObjectStreamer in our base classes derived from TObject
    //
    MArray::Class()->IgnoreTObjectStreamer();
    MParContainer::Class()->IgnoreTObjectStreamer();

    /*
    TGApplication app("Mars", &argc, argv);

#if ROOT_VERSION_CODE < ROOT_VERSION(3,10,02)
    InitGuiFactory();
#endif
    */

#ifdef HAVE_XPM
    logo.Popdown();
#endif

    //
    // start the main window
    //
    new MMars;

    //
    // run the application
    //
    app.Run();

    gLog << all << endl;

    return 0;
}
 

