#ifndef MARS_MHillasCalc
#define MARS_MHillasCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHillasCalkc                                                            //
//                                                                         //
// Task to calculate Hillas Parameters                                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif
#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasExt;
class MNewImagePar;

class MHillasCalc : public MTask
{
    const MGeomCam    *fGeomCam;    //! Camera Geometry used to calculate Hillas
    const MCerPhotEvt *fCerPhotEvt; //! Cerenkov Photon Event used for calculation

    MHillas      *fHillas;          //! output container to store result
    MHillasExt   *fHillasExt;       //! output container to store result
    MNewImagePar *fNewImgPar;       //! output container to store result

    TString      fHilName;          // name of the 'MHillas' container
    TString      fHilExtName;       // name of the 'MHillasExt' container
    TString      fImgParName;       // name of the 'MNewImagePar' container

    Int_t        fFlags;            // Flags defining the behaviour of MHillasCalc

    TArrayL      fErrors;           //! Error counter. Do we have to change to Double?

    void PrintSkipped(int i, const char *str) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    enum CalcCont_t {
        kCalcHillas      = BIT(0),
        kCalcHillasExt   = BIT(1),
        //kCalcHillasSrc   = BIT(2),
        kCalcNewImagePar = BIT(3)
    };

    MHillasCalc(const char *name=NULL, const char *title=NULL);

    void SetNameHillas(const char *name)    { fHilName = name;    }
    void SetNameHillasExt(const char *name) { fHilExtName = name; }
    void SetNameNewImgPar(const char *name) { fImgParName = name; }

    void SetFlags(Int_t f) { fFlags  =  f; }
    void Enable(Int_t f)   { fFlags |=  f; }
    void Disable(Int_t f)  { fFlags &= ~f; }
    Bool_t TestFlag(CalcCont_t i) const { return fFlags&i; }

    ClassDef(MHillasCalc, 0) // Task to calculate Hillas and other image parameters
};

#endif
