#ifndef MARS_MCameraHV
#define MARS_MCameraHV

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MCameraHV : public MParContainer
{
    friend class MReportCamera;
private:
    Bool_t  fStatus;            // Monitored status of the High Voltage, Cam.HV.PS_state
    Bool_t  fStatusPowerSupply; // Monitored status of the HV Power supply, Cam.HV_state

    Short_t fVoltageA;          // [V] Measured voltage of power supply A, hvps1
    Short_t fVoltageB;          // [V] Measured voltage of power supply B, hvps2

    Short_t fCurrentA;          // [A] Measured current of power supply A, curr1
    Short_t fCurrentB;          // [A] Measured current of power supply B, curr2

    TArrayS fHV;                // [V] Measured high Voltages for all PMTs
public:
    MCameraHV() : fHV(577) { }
    ClassDef(MCameraHV, 0)
};

#endif
