#include <TApplication.h>

#include "MAGIC.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MMars.h"
#include "MArgs.h"
#include "MArray.h"
#include "MParContainer.h"

#ifdef HAVE_XPM
#include "MLogo.h"
#endif

using namespace std;
/*
#if ROOT_VERSION_CODE < ROOT_VERSION(3,10,02)
#include <TRootGuiFactory.h>
#include <TPluginManager.h>
void InitGuiFactory()
{
    if (gROOT->IsBatch())
        gROOT->SetBatch(kFALSE);

    //
    // Must be loaded by hand, because it is not loaded by TGApplication.
    // We could also use TApplication instead, but TApplication doesn't
    // deal with the DISPLAY variable in a convient way.
    //
    TPluginHandler *h;
    if ((h = gROOT->GetPluginManager()->FindHandler("TGuiFactory", "root")))
    {
        if (h->LoadPlugin() == -1)
            return;
        gGuiFactory = (TGuiFactory*)h->ExecPlugin(0);
    }
}
#endif
*/

// **********************************************************************
//
//    MARS main program  
//
//    The only job of the main program is the initialisation of ROOT and 
//    the start of the guiinterface for the mars program
//
//    started by  h. kornmayer      january, 3rd  2001 
static void StartUpMessage()
{
    gLog << all << endl;

    //                1         2         3         4         5
    //       12345678901234567890123456789012345678901234567890
    gLog << "==================================================" << endl;
    gLog << "                    MARS V" << MARSVER              << endl;
    gLog << "    Magic Analysis and Reconstruction Software"     << endl;
    gLog << "            Compiled on <" << __DATE__ << ">"       << endl;
    gLog << "               Using ROOT v" << ROOTVER             << endl;
    gLog << "==================================================" << endl;
    gLog << endl;
}

static void Usage()
{
    gLog << all << endl;
    gLog << "Sorry the usage is:" << endl;
    gLog << "   mars [-h] [-?] [-a0] [-vn]" << endl << endl;
    gLog << "     -a0: Do not use Ansii codes." << endl;
    gLog << "     -vn: Verbosity level n [default=2]" << endl;
    gLog << "     -?/-h: This help" << endl << endl;
}

int main(int argc, char **argv)
{
    StartUpMessage();

    //
    // Evaluate arguments
    //
    MArgs arg(argc, argv);

    if (arg.HasOption("-?") || arg.HasOption("-h"))
    {
        Usage();
        return -1;
    }

    //
    // Set verbosity to highest level.
    //
    gLog.SetDebugLevel(arg.HasOption("-v") ? arg.GetIntAndRemove("-v") : 2);

    if (arg.HasOption("-a") && arg.GetIntAndRemove("-a")==0)
        gLog.SetNoColors();

#ifdef HAVE_XPM
    MLogo logo;
    logo.Popup();
#endif

    //
    // initialise ROOT
    //
    TApplication app("Mars", &argc, argv);
    if (gROOT->IsBatch() || !gClient)
    {
        gLog << "Bombing... maybe your DISPLAY variable is not set correctly!" << endl;
        return 1;
    }

    //
    // Swtich of TObjectStreamer in our base classes derived from TObject
    //
    MArray::Class()->IgnoreTObjectStreamer();
    MParContainer::Class()->IgnoreTObjectStreamer();

    /*
    TGApplication app("Mars", &argc, argv);

#if ROOT_VERSION_CODE < ROOT_VERSION(3,10,02)
    InitGuiFactory();
#endif
    */

#ifdef HAVE_XPM
    logo.Popdown();
#endif

    //
    // start the main window
    //
    new MMars;

    //
    // run the application
    //
    app.Run();

    gLog << all << endl;

    return 0;
}
 

