/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  MHCalibrationPINDiode                                                 //
//                                                                          //
//  Performs all the necessary fits to extract the mean number of photons   //
//              out of the derived light flux                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationPINDiode.h"
#include "MHCalibrationConfig.h"

#include <TStyle.h>
#include <TMath.h>

#include <TMinuit.h>
#include <TFitter.h>

#include <TF1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TPaveText.h>
#include <TRandom.h>

#include "MBinning.h"
#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MHCalibrationPINDiode);

using namespace std;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
MHCalibrationPINDiode::MHCalibrationPINDiode(const char *name, const char *title)
    : fVarGausFit(NULL)
{

    fName  = name  ? name  : "MHCalibrationPINDiode";
    fTitle = title ? title : "Fill the accumulated charges and times all PINDiode events and perform fits";

    // Create a large number of bins, later we will rebin
    fQfirst = 0;
    fQlast  = gkStartPINDiodeBinNr;
    fQnbins = gkStartPINDiodeBinNr;

    fHPQ = new TH1I("HPQ","Distribution of Summed FADC Slices",fQnbins,fQfirst,fQlast);
    fHPQ->SetXTitle("Sum FADC Slices");
    fHPQ->SetYTitle("Nr. of events");
    fHPQ->Sumw2();

    fErrQfirst = 0.;
    fErrQlast  = gkStartPINDiodeBinNr;
    fErrQnbins = gkStartPINDiodeBinNr;

    fHErrQ = new TH1F("HErrQ","Distribution of Variances of Summed FADC Slices",fErrQnbins,fErrQfirst,fErrQlast);
    fHErrQ->SetXTitle("Variance Summed FADC Slices");
    fHErrQ->SetYTitle("Nr. of events");
    fHErrQ->Sumw2();

    Int_t tfirst = 0;
    Int_t tlast  = 31;
    Int_t nbins   = 32;

    fHPT = new TH1I("HPT","Distribution of Mean Arrival Times",nbins,tfirst,tlast);
    fHPT->SetXTitle("Mean Arrival Times [FADC slice nr]");
    fHPT->SetYTitle("Nr. of events");
    fHPT->Sumw2();

}

MHCalibrationPINDiode::~MHCalibrationPINDiode()
{

  delete fHPQ;
  delete fHErrQ;
  
  if (fVarGausFit)
    delete fVarGausFit;
  
  delete fHPT;

}

