#ifndef MARS_MReportDrive
#define MARS_MReportDrive

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MReportDrive : public MReport
{
private:
    Double_t fMjd;

    Double_t fRa;         // [h]
    Double_t fDec;        // [deg]
    Double_t fHa;         // [h]

    Double_t fNominalZd;  // [deg]
    Double_t fNominalAz;  // [deg]
    Double_t fCurrentZd;  // [deg]
    Double_t fCurrentAz;  // [deg]

    Double_t fErrorZd;    // [?]
    Double_t fErrorAz;    // [?]

public:
    MReportDrive();

    Bool_t InterpreteBody(TString &str);

    ClassDef(MReportDrive, 0) // Base class for control reports
};

#endif
