#ifndef MARS_MFRandomSplit
#define MARS_MFRandomSplit
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFRandomSplit                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MF
#include "MF.h"
#endif

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;

class MFRandomSplit : public MF
{
private:

    Int_t    fNumSelectedEvts;
    Double_t fProb;   // probability with which the result should be kTRUE

    Bool_t fResult;  // Result returned by IsExpressionTrue

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MFRandomSplit(Double_t f, const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }

    ClassDef(MFRandomSplit, 0) // A Filter giving kTRUE with a certain probability
};

#endif






