#ifndef MARS_MHCalibrationPINDiode
#define MARS_MHCalibrationPINDiode

#ifndef MARS_MHCalibrationPixel
#include "MHCalibrationPixel.h"
#endif

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH1F
#include "TH1F.h"
#endif

#ifndef ROOT_TF1
#include "TF1.h"
#endif

class MHCalibrationPINDiode : public MHCalibrationPixel
{
private:

  TH1I* fHPQ;             //-> Histogram containing the summed 32 PINDiode slices
  TH1F* fHErrQ;           //-> Variance of summed FADC slices
  TH1I* fHPT;             //-> Histogram with time evolution of summed charges
  
  
  TF1 *fVarGausFit;
  
  Float_t  fErrQfirst;
  Float_t  fErrQlast;
  UShort_t fErrQnbins;

public:

  MHCalibrationPINDiode(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationPINDiode();

  const Double_t GetT()      const { return fVarGausFit->GetParameter(2); }
  const Double_t GetErrT()    const { return fVarGausFit->GetParameter(3); }

  ClassDef(MHCalibrationPINDiode, 0) 
};

#endif

