#ifndef MARS_MHCalibrationPixel
#define MARS_MHCalibrationPixel

#ifndef ROOT_TH1
#include "TH1.h"
#endif

#ifndef ROOT_TH1
#include "TH1F.h"
#endif

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TF1
#include "TF1.h"
#endif

class TPaveText;
class TMath;
class MParList;

class MHCalibrationPixel : public MH
{

private:

  Int_t fPixId;           //-> Pixel Nr
  
protected:

  TH1I* fHCharge;              //-> Summed FADC slices
  TH1I* fHTime;                //-> Mean arrival time in number of FADC sice
  TH1I* fHChargevsN;           //-> Summed Charge vs. Event Nr. 
  
  TF1* fChargeGausFit;
  TF1* fTimeGausFit;
  
  TPaveText *fFitLegend;  
  
  Axis_t  fLowerFitRange;
  Axis_t  fChargeFirst;
  Axis_t  fChargeLast;
  Int_t   fChargeNbins;

  Bool_t fFitOK;

  Double_t fChargeChisquare;
  Double_t fChargeProb;
  Int_t    fChargeNdf;

  Double_t fChargeMean;
  Double_t fChargeMeanErr;
  Double_t fChargeSigma;
  Double_t fChargeSigmaErr;
  
  Double_t fTimeChisquare;
  Double_t fTimeProb;
  Int_t    fTimeNdf;

  Double_t fTimeMean;
  Double_t fTimeSigma;
  
  virtual void DrawLegend();
  
public:

  MHCalibrationPixel(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationPixel();

  void ChangeHistId(Int_t i);
  
  Bool_t SetupFill(const MParList *pList);
  Bool_t Fill(const MParContainer *, const Stat_t w=1) { return kTRUE; }

  Bool_t FillCharge(Int_t q)               { return fHCharge->Fill(q)      > -1; }
  Bool_t FillTime(Int_t t)                 { return fHTime->Fill(t)        > -1; }
  Bool_t FillChargevsN(Float_t q, Int_t n) { return fHChargevsN->Fill(n,q) > -1; }

  const TH1I *GetHCharge()                 { return fHCharge;    }
  const TH1I *GetHCharge() const           { return fHCharge;    }

  const Double_t GetChargeMean()     const { return fChargeMean;    }
  const Double_t GetChargeMeanErr()  const { return fChargeMeanErr; }
  const Double_t GetChargeSigma()    const { return fChargeSigma;   }
  const Double_t GetChargeSigmaErr() const { return fChargeSigmaErr; }
  const Double_t GetArea()           const { return fChargeGausFit->GetParameter(0); }
  const Double_t GetAreaErr()        const { return fChargeGausFit->GetParError(0);  }

  const Double_t GetChargeChiSquare() const { return fChargeChisquare; }
  const Double_t GetChargeProb()      const { return fChargeProb;      }  
  const Int_t    GetChargeNdf()       const { return fChargeNdf;       }   

  const Double_t GetTimeMean()        const { return fTimeMean;  }
  const Double_t GetTimeSigma()       const { return fTimeSigma; }

  const Double_t GetTimeChiSquare()   const { return fTimeChisquare; }
  const Double_t GetTimeProb()        const { return fTimeProb;      }
  const Int_t    GetTimeNdf()         const { return fTimeNdf;       }   
  
  const TH1I *GetHTime()                    { return fHTime; }
  const TH1I *GetHTime()              const { return fHTime; }
  
  const TH1I *GetHChargevsN()               { return fHChargevsN; }
  const TH1I *GetHChargevsN()         const { return fHChargevsN; }
  
  Bool_t FitCharge(Option_t *option="RQ0");  
  Bool_t FitTime(Axis_t rmin=0, Axis_t rmax=0, Option_t *option="RQ0");    

  virtual void Draw(Option_t *option="");
  virtual void CutAllEdges();
  virtual void Reset();

  void SetLowerFitRange(Axis_t min)  { fLowerFitRange = min; }

  void PrintChargeFitResult();
  void PrintTimeFitResult();  

  Bool_t IsFitOK()    { return fFitOK; }
  
  ClassDef(MHCalibrationPixel, 1) 
};

#endif
