/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 11/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2002-2003
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MEventRateCalc
//
//  This task calculates the event rates from the event times and numbers.
//
//  It is under construction: More information comming soon....
//
//
//  Input Containers:
//    MTime
//
//  Output Containers:
//    MEventRate
//    MTimeRate [MTime] (missing)
//
//////////////////////////////////////////////////////////////////////////////
#include "MEventRateCalc.h"

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MTime.h"
#include "MEventRate.h"

ClassImp(MEventRateCalc);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MEventRateCalc::MEventRateCalc(const char *name, const char *title)
    : /*fNumEvents(10000),*/ fTimes(1000)
{
    fName  = name  ? name  : "MEventRateCalc";
    fTitle = title ? title : "Calculate trigger rate";
}

// --------------------------------------------------------------------------
//
// The PreProcess searches for the following input containers:
//  ...
//
Int_t MEventRateCalc::PreProcess(MParList *pList)
{
    fTime = (MTime*)pList->FindObject("MTime");
    if (!fTime)
    {
        *fLog << err << "MTime not found... aborting." << endl;
        return kFALSE;
    }

    fRate = (MEventRate*)pList->FindCreateObj("MEventRate");
    if (!fRate)
        return kFALSE;

    //fEvtNumber = 0;

    memset(fTimes.GetArray(), 0, sizeof(Double_t)*fTimes.GetSize());

    return kTRUE;
}

// --------------------------------------------------------------------------
//
//
Int_t MEventRateCalc::Process()
{
    const ULong_t exec = GetNumExecutions()-1;

    const UInt_t n = fTimes.GetSize();

    const UInt_t n1 = exec;
    const UInt_t n2 = exec>=n ? exec+1 : 0;

    fTimes[n1%n] = *fTime;

    const UInt_t cnt = n1<n2 ? n : n1-n2;

    const Double_t rate = (Double_t)cnt/(fTimes[n1%n]-fTimes[n2%n]);

    fRate->SetRate(exec>1?rate:0, cnt);
    fRate->SetReadyToSave();

    // *fLog << inf << "   ---   Event Rate [Hz]: " << rate << "  (" << cnt << ")" << endl;

    return kTRUE;
}
