#ifndef MARS_MPedestalWorkaround
#define MARS_MPedestalWorkaround

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedestalWorkaround                                                     //
//                                                                         //
// Temporary copy of pedestal values and RMS into MPedestalCam from        //
// MPedPhotCam in order to have the pedestal RMS in units of number of     // 
// photons                                                                  //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef MARS_MTask
#include "MTask.h"
#endif

class MPedestalCam;
class MPedPhotCam;
class MGeomCam;
class MParList;


class MPedestalWorkaround : public MTask 
{
private:

    MPedestalCam *fPed;  //
    MPedPhotCam *fPedPhot; //
    MGeomCam *fCam;    //

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MPedestalWorkaround(const char *name=NULL, const char *title=NULL);

    ClassDef(MPedestalWorkaround, 0) // Task to copy pedestal RMS
};

#endif



