#ifndef MARS_MReportDrive
#define MARS_MReportDrive

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MReportDrive : public MReport
{
private:
    Double_t fMjd;

    Double_t fRa;         // [h]
    Double_t fDec;        // [deg]
    Double_t fHa;         // [h]

    Double_t fNominalZd;  // [deg]
    Double_t fNominalAz;  // [deg]
    Double_t fCurrentZd;  // [deg]
    Double_t fCurrentAz;  // [deg]

    Double_t fErrorZd;    // [?]
    Double_t fErrorAz;    // [?]

    Bool_t InterpreteBody(TString &str);

public:
    MReportDrive();

    Double_t GetMjd() const       { return fMjd;       }

    Double_t GetRa() const        { return fRa;        }
    Double_t GetDec() const       { return fDec;       }
    Double_t GetHa() const        { return fHa;        }

    Double_t GetNominalZd() const { return fNominalZd; }
    Double_t GetNominalAz() const { return fNominalAz; }
    Double_t GetCurrentZd() const { return fCurrentZd; }
    Double_t GetCurrentAz() const { return fCurrentAz; }

    Double_t GetErrorZd() const   { return fErrorZd;   }
    Double_t GetErrorAz() const   { return fErrorAz;   }

    Double_t GetAbsError() const;

    ClassDef(MReportDrive, 1) // Class for DRIVE-REPORT information
};

#endif
