#ifndef MARS_MExtractSignal
#define MARS_MExtractSignal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractSignal                                                          //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MRawRunHeader;

class MPedestalCam;
class MExtractedSignalCam;

class MExtractSignal : public MTask
{
private:

  MPedestalCam             *fPedestals;    // Pedestals of all pixels in the camera
  MExtractedSignalCam      *fSignals;      // Extracted signal of all pixels in the camera

  MRawEvtData              *fRawEvt;       // raw event data (time slices)
  MRawRunHeader            *fRunHeader;    // RunHeader information

  Byte_t fFirst;
  Byte_t fLoGainFirst;

  Byte_t fNumHiGainSamples; 
  Byte_t fNumLoGainSamples; 

  Float_t fSqrtHiGainSamples; 
  Float_t fSqrtLoGainSamples; 

  Byte_t  fSaturationLimit;

  Bool_t ReInit(MParList *pList); 
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  
public:
  MExtractSignal(/*const Byte_t first=4, const Byte_t last=9,
                 const Byte_t logainshift=1,*/
                 const char *name=NULL, const char *title=NULL);

  void SetRange(Byte_t first=4, Byte_t last=9, Byte_t logainshift=1);
  void SetSaturationLimit(Byte_t lim)      { fSaturationLimit = lim; }

  ClassDef(MExtractSignal, 0) // Task to fill the Extracted Signal Containers from raw data
};

#endif
