/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  MHCalibrationPINDiode                                                 //
//                                                                          //
//  Performs all the necessary fits to extract the mean number of photons   //
//              out of the derived light flux                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationPINDiode.h"
#include "MHCalibrationConfig.h"

#include <TStyle.h>
#include <TMath.h>

#include <TMinuit.h>
#include <TFitter.h>

#include <TF1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TPaveText.h>
#include <TRandom.h>

#include "MBinning.h"
#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MHCalibrationPINDiode);

using namespace std;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
MHCalibrationPINDiode::MHCalibrationPINDiode(const char *name, const char *title)
    : fVarGausFit(NULL)
{

    fName  = name  ? name  : "MHCalibrationPINDiode";
    fTitle = title ? title : "Fill the accumulated charges and times all PINDiode events and perform fits";

    // Create a large number of bins, later we will rebin
    fChargeFirstHiGain = -1000.;
    fChargeLastHiGain  = gkStartPINDiodeBinNr;
    fChargeNbinsHiGain = gkStartPINDiodeBinNr;

    fHPCharge = new TH1I("HPCharge","Distribution of Summed FADC Slices",
			 fChargeNbinsHiGain,fChargeFirstHiGain,fChargeLastHiGain);
    fHPCharge->SetXTitle("Sum FADC Slices");
    fHPCharge->SetYTitle("Nr. of events");
    fHPCharge->Sumw2();
    fHPCharge->SetDirectory(0);

    fErrChargeFirst = 0.;
    fErrChargeLast  = gkStartPINDiodeBinNr;
    fErrChargeNbins = gkStartPINDiodeBinNr;

    fHErrCharge = new TH1F("HErrCharge","Distribution of Variances of Summed FADC Slices",fErrChargeNbins,fErrChargeFirst,fErrChargeLast);
    fHErrCharge->SetXTitle("Variance Summed FADC Slices");
    fHErrCharge->SetYTitle("Nr. of events");
    fHErrCharge->Sumw2();
    fHErrCharge->SetDirectory(0);

    Int_t tfirst = 0;
    Int_t tlast  = 31;
    Int_t nbins   = 32;

    fHPTime = new TH1I("HPTime","Distribution of Mean Arrival Times",nbins,tfirst,tlast);
    fHPTime->SetXTitle("Mean Arrival Times [FADC slice nr]");
    fHPTime->SetYTitle("Nr. of events");
    fHPTime->Sumw2();
    fHPTime->SetDirectory(0);

}

MHCalibrationPINDiode::~MHCalibrationPINDiode()
{

  delete fHPCharge;
  delete fHErrCharge;
  
  if (fVarGausFit)
    delete fVarGausFit;
  
  delete fHPTime;

}

