/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Abelardo Moralejo 1/2004 <mailto:moralejo@pd.infn.it>
!              Thomas Bretz  5/2002 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  STARMC - STandard Analysis and Reconstruction (MC example)
//
//  This macro is a version of the standard converter to convert raw data 
//  into image  parameters, made to show how to run analysis on MC files. 
//
/////////////////////////////////////////////////////////////////////////////

#include "MImgCleanStd.h"

void starmc()
{
    //
    // This is a demonstration program which calculates the image 
    // parameters from Magic Monte Carlo files (output of camera).

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;

    plist.AddToList(&tlist);

    MSrcPosCam src;
    src.SetReadyToSave();

    plist.AddToList(&src);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    MReadMarsFile read("Events");

    // ------------- user change -----------------

    read.AddFile("Gamma_zbin*.root");

    read.DisableAutoScheme();

    MGeomApply geom; // Reads in geometry from MC file and sets the right sizes for
                     // several parameter containers.

    MMcPedestalCopy   pcopy; 
    // Copies pedestal data from the MC file run fadc header to the MPedestalCam container.

    MExtractSignal    sigextract;
    // Define ADC slices to be integrated in high and low gain:
    sigextract.SetRange(0, 5, 0, 5);

    MMcCalibrationUpdate  mccalibupdate;

    //
    // Now introduce conversion factor from ADC counts to photons before camera for 
    // inner pixels. The corresponding value for outer pixels is then calculated
    // automatically. Bear in mind that the conversion factor depend both on the
    // parameters used in the camera simulation as well as on the number of 
    // integrated FADC slices. In the future it should be calculated in a previous
    // event loop, either from the same MC file or from a MC calibration file
    // written on purpose.
    // (FIXME: the conversion must be calculated automatically from the analyzed file)
    //
    mccalibupdate.SetADC2PhInner(1.2586);


    MCalibrate calib; // Transforms signals from ADC counts into photons.

    //    MBlindPixelCalc   blind;
    //    blind.SetUseInterpolation();

    MImgCleanStd      clean(4.1,3.4); // Applies tail cuts to image.


    MHillasCalc       hcalc; // Calculates Hillas parameters not dependent on source position.
    MHillasSrcCalc    scalc; // Calculates source-dependent Hillas parameters 
                             // (!!Preliminary!! Will be removed later!)


    // ------------- user change -----------------

    MWriteRootFile write("star_mc.root"); // Writes output

    write.AddContainer("MRawRunHeader", "RunHeaders");
    write.AddContainer("MMcRunHeader",  "RunHeaders");
    write.AddContainer("MSrcPosCam",    "RunHeaders");
    write.AddContainer("MMcEvt",        "Events");
    write.AddContainer("MHillas",       "Events");
    write.AddContainer("MHillasExt",    "Events");
    write.AddContainer("MHillasSrc",    "Events");
    write.AddContainer("MNewImagePar",  "Events");


    tlist.AddToList(&read);
    tlist.AddToList(&geom);
    tlist.AddToList(&pcopy);

    tlist.AddToList(&sigextract);
    tlist.AddToList(&mccalibupdate);
    tlist.AddToList(&calib);
    tlist.AddToList(&clean);
    //    tlist.AddToList(&blind);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&scalc);
    tlist.AddToList(&write);

    //
    // Create and set up the eventloop
    //
    MProgressBar bar;

    MEvtLoop evtloop;
    evtloop.SetProgressBar(&bar);
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
     //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();
}
