#ifndef MARS_MPedCalcPedRun
#define MARS_MPedCalcPedRun

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedCalcPedRun                                                          //
//                                                                         //
// Evaluate the pedestals from pedestal runs                               //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include <TArrayF.h>

class MRawEvtData;
class MPedestalCam;

class MPedCalcPedRun : public MTask
{
    Byte_t   fNumHiGainSamples;
    UShort_t fNumPixels;
    ULong_t  fNumSamplesTot;

    MRawEvtData  *fRawEvt;     // raw event data (time slices)
    MPedestalCam *fPedestals;  // Pedestals of all pixels in the camera

    TArrayF fSumx;   // sum of values
    TArrayF fSumx2;  // sum of squared values

    Bool_t ReInit(MParList *pList);

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MPedCalcPedRun(const char *name=NULL, const char *title=NULL);

    ClassDef(MPedCalcPedRun, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
