#ifndef MARS_MExtractedSignalCam
#define MARS_MExtractedSignalCam

#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;
class MExtractedSignalPix;

class MExtractedSignalCam : public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

    Byte_t fFirstUsedSliceHiGain;
    Byte_t fFirstUsedSliceLoGain;

    Byte_t fLastUsedSliceHiGain;
    Byte_t fLastUsedSliceLoGain;

public:

    MExtractedSignalCam(const char *name=NULL, const char *title=NULL);
    ~MExtractedSignalCam();

    void Print(Option_t *o="") const;
    void Clear(Option_t *o="");
    void SetLogStream(MLog *lg);

    void InitSize(const UInt_t i);
    Int_t GetSize() const;

    Byte_t GetNumUsedFADCSlices() const       { return fLastUsedSliceHiGain-fFirstUsedSliceHiGain+1; }
    Byte_t GetNumUsedHiGainFADCSlices() const { return fLastUsedSliceHiGain-fFirstUsedSliceHiGain+1; }
    Byte_t GetNumUsedLoGainFADCSlices() const { return fLastUsedSliceLoGain-fFirstUsedSliceLoGain+1; }

    Byte_t GetFirstUsedSliceHiGain() const    { return fFirstUsedSliceHiGain; }
    Byte_t GetLastUsedSliceHiGain() const     { return fLastUsedSliceHiGain; }

    Byte_t GetFirstUsedSliceLoGain() const    { return fFirstUsedSliceLoGain; }
    Byte_t GetLastUsedSliceLoGain() const     { return fLastUsedSliceLoGain; }

    void   SetUsedFADCSlices(Byte_t firsth, Byte_t lasth, 
                             Byte_t firstl, Byte_t lastl)
    {
      fFirstUsedSliceHiGain    = firsth;
      fLastUsedSliceHiGain     = lasth;
      fFirstUsedSliceLoGain    = firstl;
      fLastUsedSliceLoGain     = lastl;
    }

    MExtractedSignalPix &operator[](Int_t i);
    const MExtractedSignalPix &operator[](Int_t i) const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t num) const;

    ClassDef(MExtractedSignalCam, 0)	// Storage Container for extracted signals in the camera
};

#endif

