#ifndef MARS_MPedestalCam
#define MARS_MPedestalCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MPedestalPix;

class MPedestalCam : public MParContainer, public MCamEvent
{
private:
    TClonesArray *fArray; // FIXME: Change TClonesArray away from a pointer?

    ULong_t fNumTotSlices;
    Byte_t  fNumExtractSlices;

    Bool_t fUseHists;
    
public:
    MPedestalCam(const char *name=NULL, const char *title=NULL);
    ~MPedestalCam();

    void Clear(Option_t *o="");
    
    void InitSize(const UInt_t i);

    void InitUseHists();

    MPedestalPix &operator[](Int_t i);
    MPedestalPix &operator[](Int_t i) const;

    // Setters
    void SetNumTotSlices(ULong_t n)    { fNumTotSlices = n; }
    void SetNumExtractSlices(Byte_t n)   { fNumExtractSlices = n; }

    // Getters
    Int_t   GetSize()                          const;
    Float_t GetPedestalMin(const MGeomCam *cam) const;
    Float_t GetPedestalMax(const MGeomCam *cam) const;
    Bool_t  IsUseHists()                       const  { return fUseHists; }
    
    
    void Print(Option_t *o="") const;

    Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
    void DrawPixelContent(Int_t idx) const;

    ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

