#ifndef MARS_MHCalibrationPINDiode
#define MARS_MHCalibrationPINDiode

#ifndef MARS_MHCalibrationPixel
#include "MHCalibrationPixel.h"
#endif

class TH1I;
class TH1F;
class TF1;
class TPaveText;

class MHCalibrationPINDiode : public MHCalibrationPixel
{
private:

  TH1F* fHPINDiodeCharge;    // Histogram containing the summed 32 PINDiode slices
  TH1F* fHPINDiodeErrCharge; // Variance of summed FADC slices
  TH1F* fHPINDiodeTime;      // Histogram with time evolution of summed charges
  
  TH1I* fHPINDiodeChargevsN; // Summed Charge vs. Event Nr.
  
  const Int_t   fChargeNbins;
  const Int_t   fTimeNbins;
  const Int_t   fChargevsNbins;

  const Axis_t  fTimeFirst;
  const Axis_t  fTimeLast;

public:

  MHCalibrationPINDiode(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationPINDiode();

  void Clear(Option_t *o="");
  void Reset();

  // Fill histos
  Bool_t FillCharge(Float_t q);
  Bool_t FillTime(Float_t t);
  Bool_t FillChargevsN(Float_t q, Int_t n);

  // Fits -- not yet implemented
  Bool_t FitCharge(Option_t *option="RQ0") { return kTRUE; }
  Bool_t FitTime(Option_t *option="RQ0")   { return kTRUE; }

  // Others
  void CutAllEdges();
  
  ClassDef(MHCalibrationPINDiode, 0)  // Histograms from the Calibration PIN Diode
};

#endif

