#ifndef MARS_MHExtractedSignalPix
#define MARS_MHExtractedSignalPix

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class TH1F;
class TH1I;
class TF1;
#include "TH1.h" // Axis_t

class MHExtractedSignalPix : public TObject
{
private:

  static const Int_t  gkChargeNbins;
  static const Int_t  gkChargevsNbins;
  static const Axis_t gkChargevsNFirst;
  static const Axis_t gkChargevsNLast;
  static const Axis_t gkChargeFirst;
  static const Axis_t gkChargeLast;

  
  Int_t fPixId;                  // Pixel Nr

  TH1F* fHPedestalCharge;               //-> Summed FADC slices
  TH1I* fHPedestalChargevsN;            //-> Summed FADC slices vs Event nr.
  TF1*  fGausFit;                       // Fit the the Summed FADC slices
  
  Int_t    fTotalEntries;              // Number of entries

  Double_t fChargeChisquare;
  Double_t fChargeProb;
  Int_t    fChargeNdf;

  Double_t fChargeMean;
  Double_t fChargeMeanErr;
  Double_t fChargeSigma;
  Double_t fChargeSigmaErr;

  Byte_t   fFlags;

  enum { kFitted, kFitOK, kOscillating };

public:

  MHExtractedSignalPix(/*const char *name=NULL, const char *title=NULL*/);
  ~MHExtractedSignalPix();
  
  void Clear(Option_t *o="");
  void Reset();

  void ChangeHistId(Int_t i);

  // Getters
  const TH1F *GetHPedestalCharge() const { return fHPedestalCharge; }

  Double_t GetChargeMean()      const { return fChargeMean;      }
  Double_t GetChargeMeanErr()   const { return fChargeMeanErr;   }
  Double_t GetChargeSigma()     const { return fChargeSigma;     }
  Double_t GetChargeSigmaErr()  const { return fChargeSigmaErr;  }
  Double_t GetChargeChiSquare() const { return fChargeChisquare; }
  Double_t GetChargeProb()      const { return fChargeProb;      }
  Int_t    GetChargeNdf()       const { return fChargeNdf;       }

  Int_t    GetTotalEntries()    const { return fTotalEntries;    }     
  
  Bool_t IsFitOK()       const;
  Bool_t IsFitted()      const;
  Bool_t IsEmpty()       const;
  Bool_t IsOscillating() const;
  
  // Fill histos
  Bool_t FillCharge(Float_t q);
  Bool_t FillChargevsN(Float_t q);
  
  // Fits
  Bool_t FitCharge(Option_t *option="RQ0");
  
  // Draws
  void Draw(Option_t *option="");
  TObject *DrawClone(Option_t *option="") const;
  
  // Prints
  void Print(const Option_t *o="") const;
  
  // Others
  void CutAllEdges();
  
  ClassDef(MHExtractedSignalPix, 1)     // Histograms for each calibrated pixel
};

#endif
