#ifndef MARS_MPedestalCam
#define MARS_MPedestalCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MPedestalPix;
class MHPedestalPixel;

class MPedestalCam : public MH, public MCamEvent
{

 private:

  static const UInt_t gkBlindPixelId;
  
  TClonesArray *fArray;  // FIXME: Change TClonesArray away from a pointer?
  
  TObjArray    *fHArray; //-> List of Lo/Hi gain Histograms
  
  ULong_t fTotalEntries;
  Float_t fExtractSlices;
  
public:
  MPedestalCam(const char *name=NULL, const char *title=NULL);
  ~MPedestalCam();
  
  void Clear(Option_t *o="");
  
  void InitSize(const UInt_t i);
  
  MPedestalPix &operator[](Int_t i);
  MPedestalPix &operator[](Int_t i) const;
  
  MHPedestalPixel &operator()(UInt_t i);
  MHPedestalPixel &operator()(UInt_t i) const;
  
  Bool_t SetupFill(const MParList *pList);
  Bool_t Fill(const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize();
  
  TObject *Clone(const char *) const;
  
  // Setters
  void SetTotalEntries(ULong_t n)    { fTotalEntries = n; }

  // Getters
  Int_t   GetSize()                          const;
  Int_t   GetHistSize()                      const;  
  ULong_t GetTotalEntries()                  const { return fTotalEntries; }
  Float_t GetPedestalMin(const MGeomCam *cam) const;
  Float_t GetPedestalMax(const MGeomCam *cam) const;
  
  void Print(Option_t *o="") const;
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;
  
  ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

