#ifndef MARS_MCalibrationBlindPix
#define MARS_MCalibrationBlindPix

#ifndef MARS_MHCalibrationBlindPixel
#include "MHCalibrationBlindPixel.h"
#endif

class MCalibrationBlindPix : public MParContainer
{
private:

  MHCalibrationBlindPixel *fHist; // Pointer to the histograms performing the fits, etc.  

  Float_t fLambda;           // The mean charge after the fit
  Float_t fMu0;              // The position of the pedestal-peak
  Float_t fMu1;              // The position of the first phe-peak
  Float_t fSigma0;           // The width of the pedestal-peak
  Float_t fSigma1;           // The width of the first phe-peak  

  Float_t fErrLambda;        // The error of the mean charge after the fit
  Float_t fErrMu0;           // The error of the position of the pedestal-peak
  Float_t fErrMu1;           // The error of the position of the first phe-peak
  Float_t fErrSigma0;        // The error of the width of the pedestal-peak
  Float_t fErrSigma1;        // The error of the width of the first phe-peak  
  
  Float_t fTime;                // The mean arrival time after the fit  
  Float_t fErrTime;             // The error of the mean arrival time after the fit
  
  
public:

  MCalibrationBlindPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationBlindPix();
  
  void Clear(Option_t *o="");
  
  // Getters
  Float_t GetLambda()    const    { return fLambda;  }
  Float_t GetMu0()       const    { return fMu0;  }
  Float_t GetMu1()       const    { return fMu1;  }
  Float_t GetSigma0()    const    { return fSigma0;  }
  Float_t GetSigma1()    const    { return fSigma1;  }

  Float_t GetErrLambda() const    { return fErrLambda;  }
  Float_t GetErrMu0()    const    { return fErrMu0;  }
  Float_t GetErrMu1()    const    { return fErrMu1;  }
  Float_t GetErrSigma0() const    { return fErrSigma0;  }
  Float_t GetErrSigma1() const    { return fErrSigma1;  }

  Float_t GetTime()      const    { return fTime;         }
  Float_t GetErrTime()   const    { return fErrTime;      }
  
  MHCalibrationBlindPixel *GetHist()     const  { return fHist;  }
  MHCalibrationBlindPixel *GetHist()            { return fHist;  }
  
  Bool_t IsFitOK()  const;
  
  // Fill histos
  Bool_t FillCharge(const Float_t q); 
  Bool_t FillTime(const Float_t t); 
  Bool_t FillRChargevsTime(const Float_t rq, const Int_t t);
  
  // Fits
  Bool_t FitCharge();
  Bool_t FitTime();
  void ChangeFitFunc(MHCalibrationBlindPixel::FitFunc_t f) const  { fHist->ChangeFitFunc(f); }
  
  // Draws
  void Draw(Option_t *opt="")                  { fHist->Draw(opt); }
  TObject *DrawClone(Option_t *opt="") const  {  return fHist->DrawClone(opt); }  
  
  ClassDef(MCalibrationBlindPix, 1)	// Storage Container for Calibration information of one pixel
};

#endif

