#ifndef MARS_MH
#define MARS_MH

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TH1;
class TH1I;
class TH1D;
class TH2;
class TH3;
class TAxis;
class TArrayF;
class TArrayD;
class TCanvas;

class MBinning;
class MParList;

class MH : public MParContainer
{
private:
    Byte_t fSerialNumber;

public:
    MH(const char *name=NULL, const char *title=NULL);


    virtual void SetSerialNumber(Byte_t num) { fSerialNumber = num; }
    Byte_t  GetSerialNumber() const { return fSerialNumber; }
    TString AddSerialNumber(const char *str) const { TString s(str); if (fSerialNumber==0) return s; s += ";"; s += fSerialNumber; return s; }
    TString AddSerialNumber(const TString &str) const { return AddSerialNumber((const char*)str); }

    Bool_t OverwritesDraw(TClass *cls=NULL) const;

    virtual Bool_t SetupFill(const MParList *pList) { return kTRUE; }
    virtual Bool_t ReInit(MParList *pList) { return kTRUE; }
    virtual Bool_t Fill(const MParContainer *par, const Stat_t weight=1);
    virtual Bool_t Finalize() { return kTRUE; }

    virtual TString GetDataMember() const { return ""; }

    virtual TH1 *GetHistByName(const TString name);

    static TCanvas *MakeDefCanvas(TString name="", const char *title="",
                                  UInt_t w=625, UInt_t h=440,
                                  Bool_t usescreenfactor=kTRUE);
    static TCanvas *MakeDefCanvas(const TObject *obj,
                                  UInt_t w=625, UInt_t h=440,
                                  Bool_t usescreenfactor=kFALSE);

    // FIXME: * --> & !!!

    static void SetBinning(TH1 *h, const MBinning *binsx);
    static void SetBinning(TH2 *h, const MBinning *binsx, const MBinning *binsy);
    static void SetBinning(TH3 *h, const MBinning *binsx, const MBinning *binsy, const MBinning *binsz);

    static void SetBinning(TH1 *h, const TArrayD &binsx);
    static void SetBinning(TH2 *h, const TArrayD &binsx, const TArrayD &binsy);
    static void SetBinning(TH3 *h, const TArrayD &binsx, const TArrayD &binsy, const TArrayD &binsz);

    static void SetBinning(TH1 *h, const TAxis *binsx);
    static void SetBinning(TH2 *h, const TAxis *binsx, const TAxis *binsy);
    static void SetBinning(TH3 *h, const TAxis *binsx, const TAxis *binsy, const TAxis *binsz);

    static void SetBinning(TH1 *h, const TH1 *x);

    static Bool_t ApplyBinning(const MParList &plist, TString name, TH1 *h);

    static void    ScaleArray(TArrayD &bins, Double_t f);
    static TArrayD ScaleAxis(TAxis &axe, Double_t f);
    static void    ScaleAxis(TH1 *bins, Double_t fx=1, Double_t fy=1, Double_t fz=1);

    static Double_t GetBinCenterLog(const TAxis &axe, Int_t nbin);

    static void DrawSameCopy(const TH1 &hist1, const TH1 &hist2, const TString title);
    static void DrawSame(TH1 &hist1, TH1 &hist2, const TString title);

    TObject *Clone(const char *name="") const;

    TObject *DrawClone(Option_t *opt, Int_t w, Int_t h) const;
    TObject *DrawClone(Option_t *opt="") const
    {
        return MH::DrawClone(opt, 625, 440);
    }

    static TVirtualPad *GetNewPad(TString &opt);

    static void FindGoodLimits(Int_t nbins, Int_t &newbins, Double_t &xmin, Double_t &xmax, Bool_t isInteger);
    static Double_t GetMinimumGT(const TH1 &h, Double_t gt=0);
    static Int_t CutEdges(TH1 *h, Int_t nbins);

    static TH1I* ProjectArray(const TArrayF *array, Int_t nbins=30, const char* name="ProjectArray",
                                                              const char* title="Projected Array");
    static TH1I* ProjectArray(const TArrayD *array, Int_t nbins=30, const char* name="ProjectArray",
                                                              const char* title="Projected Array");
    
    static void ProjectionX(TH1D &dest, const TH2 &src, Int_t firstybin=-1, Int_t lastybin=9999);
    static void ProjectionY(TH1D &dest, const TH2 &src, Int_t firstxbin=-1, Int_t lastxbin=9999);

    static TObject *FindObjectInPad(const char *name, TVirtualPad *pad=NULL);

    ClassDef(MH, 1) //A base class for Mars histograms
};

#endif

