#ifndef MARS_MRawRead
#define MARS_MRawRead

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MTime;
class MParList;
class MRawRunHeader;
class MRawEvtHeader;
class MRawEvtData;
class MRawCrateArray;

class MRawRead : public MTask
{
protected:
    MRawRunHeader  *fRawRunHeader;  // run header information container to fill from file
    MRawEvtHeader  *fRawEvtHeader;  // event header information container to fill from file
    MRawEvtData    *fRawEvtData;    // raw evt header infomation container to fill from file
    MRawCrateArray *fRawCrateArray; // crate information array container to fill from file
    MTime          *fRawEvtTime;    // raw evt time information container to fill from file

    void CreateFakeTime() const;

    Bool_t ReadEvent(istream &fin);
    Int_t  PreProcess(MParList *pList);

private:
    virtual Bool_t OpenStream() { return kTRUE; }

public:
    MRawRead(const char *name=NULL, const char *title=NULL);

    ClassDef(MRawRead, 0)	// Task to read the raw data binary file
};

#endif
