#ifndef MARS_MHGausEvent
#define MARS_MHGausEvent

#ifndef MARS_MH
#include "MH.h"
#endif

class TArrayF;
class TH1F;
class TH1I;
class TF1;
class MHGausEvent : public MH
{
private:

  Bool_t   fGausFitOK;
  Bool_t   fExpFitOK;  
  Bool_t   fOscillating;

  Double_t fMean;
  Double_t fSigma;
  Double_t fMeanErr;
  Double_t fSigmaErr;

  Double_t fProb;
  
protected:

  TH1F*    fHGausHist;
  TH1I*    fHPowerProbability;
  
  TF1*     fFGausFit; 
  TF1*     fFExpFit;
  
  TArrayF *fEvents;
  TArrayF *fPowerSpectrum;   

  Int_t    fGausHistBins;
  Axis_t   fGausHistAxisFirst;
  Axis_t   fGausHistAxisLast;  

  Int_t    fPowerProbabilityBins;
  Float_t  fProbLimit;

  void CutArrayBorder(TArrayF *array);

public:

  MHGausEvent(const char *name=NULL, const char *title=NULL);
  ~MHGausEvent();

  void Clear(Option_t *o="");
  void Reset();  

  const Double_t GetMean()             const { return fMean;  }
  const Double_t GetMeanErr()           const { return fMeanErr;  }
  const Double_t GetSigma()            const { return fSigma;  }
  const Double_t GetSigmaErr()           const { return fSigmaErr;  }
  const Double_t GetChiSquare()           const;
  const Double_t GetProb()            const { return fProb;  }
  const Int_t    GetNdf()             const;

  const Double_t GetSlope() const;
  const Double_t GetOffset()   const;
  const Double_t GetExpChiSquare() const;
  const Double_t GetExpProb()    const;
  const Int_t    GetExpNdf()    const;

  const TH1F *GetHGausHist()                   { return fHGausHist;   }
  const TH1F *GetHGausHist()             const { return fHGausHist;   } 

  const TF1 *GetFGausFit()                   { return fFGausFit;   }
  const TF1 *GetFGausFit()             const { return fFGausFit;   } 

  const TH1I *GetHPowerProbability()                   { return fHPowerProbability;   }
  const TH1I *GetHPowerProbability()             const { return fHPowerProbability;   } 

  const TF1 *GetFExpFit()                   { return fFExpFit;   }
  const TF1 *GetFExpFit()             const { return fFExpFit;   } 

  Bool_t CheckOscillations();
  
  virtual Bool_t IsGausFitOK()          const { return fGausFitOK; }
  virtual Bool_t IsExpFitOK()           const { return fExpFitOK; }  
  virtual Bool_t IsEmpty()              const;
  virtual Bool_t IsOscillating();
  
  // Fits
  virtual Bool_t FitGaus(Option_t *option="RQ0");  

  // Prints
  virtual void Print(const Option_t *o="") const;

  ClassDef(MHGausEvent, 1)     // Histograms for events with Gaussian distributed values
};

#endif
