/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!   Author(s): Abelardo Moralejo 4/2003 <mailto:moralejo@pd.infn.it>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

void CT1collarea(TString filename="MC_SC4.root", TString outname="")
{ 

    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    parlist.AddToList(&tasklist);

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can fill the efficiency histograms
    //
    MReadMarsFile reader("Events", filename);
    reader.DisableAutoScheme();

    MHMcCT1CollectionArea collarea;

    MBinning binsx("BinningE");

    /*
    Double_t xedge[15] = {2.47712, 2.64345, 2.82607, 3., 3.17609, 3.35218, 3.52892, 3.70415, 3.88024, 4.05652, 4.23274, 4.40875, 4.58478, 4.76080, 4.90309};
    const TArrayD xed;
    xed.Set(15,xedge);
    binsx.SetEdges(xed);
    collarea.SetEaxis(MHMcCollectionArea::kLog10);
    */

    //
    // SetEaxis tells MHMcCT1CollectionArea whether the variable to histogram
    // is the Energy (argument is kEnergy) or its decimal logarithm 
    // (kLog10Energy). Of course this depends on how the energy binning is 
    // defined via the object binsx. 
    //
    binsx.SetEdgesLog(14,300,1.e5);
    collarea.SetEaxis(MHMcCT1CollectionArea::kLinear);


    MBinning binsy("BinningTheta");
    const Double_t yedge[9] = {0.0, 17.5, 23.5, 29.5, 35.5, 42., 50., 60., 70.};
    const TArrayD yed;
    yed.Set(9,yedge);
    binsy.SetEdges(yed);

    parlist.AddToList(&collarea);
    parlist.AddToList(&binsx);
    parlist.AddToList(&binsy);

    tasklist.AddToList(&reader);   

    MF filterhadrons("HadSC.fHadronness<0.3 && {abs(MHillasSrc.fAlpha)} < 13.1");
    tasklist.AddToList(&filterhadrons);


    MFillH filler("MHMcCT1CollectionArea","MMcEvt");
    filler.SetFilter(&filterhadrons);
    tasklist.AddToList(&filler);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    MProgressBar bar;
    magic.SetProgressBar(&bar);
    if (!magic.Eventloop())
        return;

    tasklist.PrintStatistics();

    collarea.CalcEfficiency();

    //
    // Now the histogram we wanted to get out of the data is
    // filled and can be displayed
    //
    collarea.DrawClone();

    //
    // Write histogram to a file in case an output
    // filename has been supplied
    //
    if (outname.IsNull())
        return;

    TFile f(outname,"recreate");
    collarea.GetHist()->Write();
    collarea.GetHAll()->Write();
    collarea.GetHSel()->Write();
}

