#ifndef MARS_MHOnSubtraction
#define MARS_MHOnSubtraction

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1D;
class TH3D;
class TPad;
class TGraph;
class TLegend;
class TPaveLabel;

class MHArray;

class MHOnSubtraction : public MH
{
private:
  TString fHistogramType;
  TH1D*   fChiSquareHisto;
  TH1D*   fSignificanceHisto;
  TH1D*   fSummedAlphaPlots;
  MHArray *fThetaHistoArray;
  TLegend *fThetaLegend;
  Double_t fMaxSignif;
  Double_t fMaxRedChiSq;
  Double_t fSlope;             // slope for exponential fit
  Int_t fThetaBin;
  Int_t fSigniPlotIndex;
  Int_t fSigniPlotColor;

  Double_t fSignificance;

  Bool_t CalcAET(TH3D *histon, MParList *parlist, const Bool_t Draw);

  Bool_t FitHistogram(TH1 &alphaHisto, Double_t &sigLiMa,
		      Double_t &lowerBin, Double_t &upperBin,
		      Float_t signalRegionFactor = 3, const Bool_t draw = kFALSE,
		      TString funcName = "");

  Bool_t ExtractSignal(TH1 &alphaHisto, Double_t &sigLiMa,
		       Double_t &lowerBin, Double_t &upperBin,
		       Double_t &gammaSignal, Double_t &errorGammaSignal,
		       Double_t &off, Double_t &errorOff,
 		       Float_t signalRegionFactor = 3, const Bool_t draw = kFALSE,
 		       TString funcName = "", TPad *drawPad = 0, Int_t drawBase = 0);



public:
  MHOnSubtraction(const char *name=NULL, const char *title=NULL);
  ~MHOnSubtraction();

  Double_t CalcSignificance(Double_t nOn, Double_t nOff, Double_t theta);
  Double_t GetSignificance()  { return fSignificance; };

  void SetExpoSlope(Double_t slope) { fSlope = slope; }
  
  Bool_t Calc(MParList *parlist, const Bool_t Draw);

  Bool_t Calc(TH3 *histon, MParList *parlist, const Bool_t Draw);
  Bool_t TH2Calc(TH2 *aeHisto, MParList *parlist, const Bool_t Draw, 
		 TPad *drawPad = 0, Int_t drawBase = 0);
  Bool_t Calc(TH1 *histon, MParList *parlist, const Bool_t Draw,
	      Float_t signalRegion = 0);

  void Draw(Option_t *option="");
  TObject *DrawClone(Option_t *option="") const;

  ClassDef(MHOnSubtraction, 1) //Extracts gamma signals from pure ON-data
};

#endif

