#ifndef MARS_MJPedestal
#define MARS_MJPedestal

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif


class TCanvas;
class MParList;
class MRunIter;
class MHCamera;

class MJPedestal : public MParContainer
{
private:
    TString fOutputPath;

    MRunIter *fRuns;

    MPedestalCam  fPedestalCam;
    MBadPixelsCam fBadPixels;

    Bool_t ReadPedestalCam();
    Bool_t WriteResult();
    
    void   DrawProjection(MHCamera *obj1, Int_t fit) const;
    void   CamDraw(TCanvas &c, Int_t x, Int_t y, MHCamera &cam1, Int_t fit);
    void   DisplayResult(MParList &plist);

public:
    MJPedestal(const char *name=NULL, const char *title=NULL);

    void SetOutputPath(const char *path=".");
    void SetInput(MRunIter *iter) { fRuns=iter; }

    TString GetOutputFile() const;

    const MPedestalCam  &GetPedestalCam() const { return fPedestalCam; }
    const MBadPixelsCam &GetBadPixels()   const { return fBadPixels; }

    void SetBadPixels(MBadPixelsCam &bad) { bad.Copy(fBadPixels); }

    Bool_t ProcessFile();
    Bool_t Process();

    ClassDef(MJPedestal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
