#ifndef MARS_MHCalibrationChargePix
#define MARS_MHCalibrationChargePix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class TH1F;
class MHCalibrationChargePix : public MHGausEvents
{

private:

  static const Int_t   fgChargeNbins;
  static const Axis_t  fgChargeFirst;
  static const Axis_t  fgChargeLast;  

  static const Int_t   fgAbsTimeNbins;
  static const Axis_t  fgAbsTimeFirst;
  static const Axis_t  fgAbsTimeLast;

  static const Float_t fgPickupLimit;

protected:

  static const Int_t   fgPulserFrequency;

  Int_t    fPixId;

  TH1F     fHAbsTime;          // Histogram to hold the absolute arrival times in number of FADC slices
                          
  Int_t    fChargeNbins;
  Axis_t   fChargeFirst;
  Axis_t   fChargeLast;

  Int_t    fAbsTimeNbins;
  Axis_t   fAbsTimeFirst;
  Axis_t   fAbsTimeLast;

  Float_t    fPickupLimit;      // The limit in number of sigmas from the fitted mean above which events are considered as pickup

  Float_t  fSaturated;
  Float_t  fPickup;

  Byte_t   fFlags;
  enum     { kExcluded };

public:

  MHCalibrationChargePix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargePix() {}

  virtual void Clear(Option_t *o="");
  virtual void Reset();  
  virtual void Init();
  virtual void ChangeHistId(Int_t i);
  
  // Setters
  virtual void SetChargeNbins(const Int_t  bins =fgChargeNbins)    { fChargeNbins = bins; }
  virtual void SetChargeFirst(const Axis_t first=fgChargeFirst)    { fChargeFirst = first; }
  virtual void SetChargeLast( const Axis_t last =fgChargeLast)     { fChargeLast  = last; }
  
  virtual void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)  { fAbsTimeNbins = bins; }
  virtual void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)  { fAbsTimeFirst = first; }
  virtual void SetAbsTimeLast( const Axis_t last =fgAbsTimeLast)   { fAbsTimeLast  = last; }

  virtual void SetPickupLimit( const Float_t  lim =fgPickupLimit)    { fPickupLimit  = lim; }

  void SetPulserFrequency(Float_t f=fgPulserFrequency);

  void SetSaturated      ( const Float_t f    )                   { fSaturated += f; }
  void SetExcluded       ( const Bool_t b=kTRUE );

  // Getters
  TH1F *GetHAbsTime()                       { return &fHAbsTime;  }
  const TH1F *GetHAbsTime()           const { return &fHAbsTime;  }

  const Float_t  GetIntegral()        const;
  
  const Float_t  GetAbsTimeMean()     const;
  const Float_t  GetAbsTimeRms()      const;

  const Float_t    GetSaturated()       const { return fSaturated;   }
  const Float_t    GetPickup()          const { return fPickup;      }

  Bool_t   IsExcluded()         const;

  // Fill histos
  Bool_t FillAbsTime(const Float_t t);

  // Fits
  void   BypassFit();
  Bool_t RepeatFit(const Option_t *option="RQ0");
  
  // Draws
  virtual void Draw(Option_t *opt="");

  // Miscelleaneous
  void CountPickup();

  ClassDef(MHCalibrationChargePix, 1)     // Base class for charge calibrated pixel
};

#endif
