#ifndef MARS_MF
#define MARS_MF

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MF                                                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class TMethodCall;

class MF : public MFilter
{
private:
    static const TString gsDefName;  //!
    static const TString gsDefTitle; //!

    MFilter *fF; // Filter

    Int_t IsRule(TString &txt, TString &rule) const;
    Int_t IsVal(const TString &txt) const;
    Int_t IsAlNum(TString txt) const;

    MFilter *ParseRule(TString &txt, MFilter *filter0, Int_t level) const;
    MFilter *ParseString(TString txt, Int_t level);

    void StreamPrimitive(ofstream &out) const;

public:
    MF();
    MF(const char *text, const char *name=NULL, const char *title=NULL);
    ~MF();

    Bool_t IsExpressionTrue() const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    void Print(Option_t *opt="") const;

    void SetVariables(const TArrayD &arr) { if (fF) fF->SetVariables(arr); }

    ClassDef(MF, 0) // A Filter for cuts in any data member
};

#endif
