#ifndef MARS_MHEnergyTheta
#define MARS_MHEnergyTheta

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MTime;
class MParList;

class MHEnergyTheta : public MH
{
private:
    TH2D fHist; //! 

public:
    MHEnergyTheta(const char *name=NULL, const char *title=NULL);

    Bool_t Fill(const MParContainer *cont, const Stat_t w=1);

    void Draw(Option_t *option="");

    Bool_t SetupFill(const MParList *plist);

    const TH2D *GetHist() { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Divide(const TH2D *h1, const TH2D *h2);
    void Divide(const MHEnergyTheta *h1, const MHEnergyTheta *h2)
    {
        Divide(h1->GetHist(), h2->GetHist());
    }

    ClassDef(MHEnergyTheta, 1)  // Histogram: Energy vs. Theta
};

#endif
