#ifndef MARS_MHVsTime
#define MARS_MHVsTime

#ifndef MARS_MH
#include "MH.h"
#endif

class TGraph;
class MDataChain;

class MHVsTime : public MH
{
protected:
    // Could be const but root < 3.02/06 doesn't like this...
    TGraph     *fGraph;  // Histogram to fill
    MDataChain *fData;  // Object from which the data is filled
    Double_t    fScale; // Scale for axis (eg unit)

    enum {
        kIsLogy = BIT(18),
        kUseEventNumber = BIT(20)
    };

    Bool_t fUseEventNumber;

public:
    MHVsTime(const char *rule=NULL);
    ~MHVsTime();

    void SetScale(Double_t scale) { fScale = scale; }

    Int_t GetNbins() const;

    void SetName(const char *name);
    void SetTitle(const char *title);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    TString GetDataMember() const;
    TString GetRule() const;

    /*
//    const TH1 *GetHist() const;
//    TH1 *GetHist();
//    TH1 *GetHistByName(const TString name="");
*/
    const TGraph *GetGraph() const { return fGraph; }
    TGraph *GetGraph() { return fGraph; }

    void SetUseEventNumber(Bool_t use = kTRUE) { fUseEventNumber = use; }

    void Draw(Option_t *opt=NULL);

    MParContainer *New() const;

    ClassDef(MHVsTime, 1) // Generalized 1/2/3D-histogram for Mars variables
};

#endif
