#ifndef MARS_MIslands
#define MARS_MIslands

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif


class MIslands : public MParContainer
{
private:
    // for description see MIslands.cc
    Int_t fIslNum;                    //    number of islands
    Int_t fPixNum[30];                //    number of pixels in the island
    Float_t fSigToNoise[30] ;         //    signal to noise of the island

public:
    MIslands(const char *name=NULL, const char *title=NULL);
    ~MIslands();

    Int_t    GetIslNum() const                        { return fIslNum; }
    Int_t    GetPixNum(Int_t i) const                 { return fPixNum[i]; }
    Float_t  GetSigToNoise(Int_t i) const             { return fSigToNoise[i]; } 
    void     SetIslNum(Int_t i)                       { fIslNum = i; }
    void     SetPixNum(Int_t i, Int_t j)              { fPixNum[i] = j; }
    void     SetSigToNoise(Int_t i, Float_t m)        { fSigToNoise[i] = m; }
   
    ClassDef(MIslands, 1) // Storage Container for Island Parameters
};

#endif
