/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug  04/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  calibClasses
//
//  This macro draws the scheme found in htmldoc/images/CalibClasses.gif
//
/////////////////////////////////////////////////////////////////////////////

void calibClasses()
{

  const Float_t ell1x1 = 0.3;
  const Float_t ell2x1 = 0.575;
  const Float_t ell3x1 = 0.85;
  
  const Float_t ellr1 = 0.12;
  const Float_t ellr2 = 0.035;
  
  const Float_t tex1x1 = 0.19;
  const Float_t tex2x1 = 0.465;
  const Float_t tex3x1 = 0.74;


  const Float_t texsize = 0.0257913;
  const Float_t texsize2 = 0.015;

  const Float_t arr1x1 = 0.3;
  const Float_t arr2x1 = 0.575;
  const Float_t arr3x1 = 0.85;

  const Float_t arrsize = 0.02;
  
  const Float_t pt1x1 = 0.175;
  const Float_t pt2x1 = 0.45;
  const Float_t pt3x1 = 0.725;

  const Float_t pt1x2 = 0.425;
  const Float_t pt2x2 = 0.7;
  const Float_t pt3x2 = 0.975;


  Float_t arry1 = 0.;
  Float_t arry2 = 0.;
  Float_t elly1 = 0.;
  Float_t pty1  = 0.;
  Float_t pty2  = 0.;
  Float_t texy1 = 0.;

  TCanvas *CalibClasses = new TCanvas("CalibClasses", "Calibration Classes",89,96,758,1051);
  CalibClasses->Range(0,0,1,1);
  CalibClasses->SetBorderSize(2);
  CalibClasses->SetFrameFillColor(0);
   
// First line:
   TPaveText *pt = new TPaveText(0.375,0.895,0.785,0.95,"br");
   pt->SetFillColor(18);
   TText *text = pt->AddText("MRawEvtData");
   pt->Draw();
      tex = new TLatex(0.55,0.955,"C");
   tex->SetTextSize(0.05);
   tex->SetLineWidth(2);
   tex->Draw();
      tex = new TLatex(0.12,0.955,"P");
   tex->SetTextSize(0.05);
   tex->SetLineWidth(2);
   tex->Draw();
   
   pt = new TPaveText(0.015,0.875,0.25,0.95,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MPedestalCam:");
   text = pt->AddText("ped, RMS, #Deltaped, #DeltaRMS");
   pt->Draw();
   

// Second line:
   elly1 = 0.805;

   TEllipse *ellipse = new TEllipse(ell1x1,elly1,ellr1,ellr2,0,360,0);
   ellipse->Draw();
   
   ellipse = new TEllipse(ell2x1,elly1,ellr1,ellr2,0,360,0);
   ellipse->Draw();
   
   ellipse = new TEllipse(ell3x1,elly1,ellr1,ellr2,0,360,0);
   ellipse->Draw();

   texy1 = 0.805;

      tex = new TLatex(tex1x1,texy1,"MExtractSignal:");
   tex->SetTextSize(texsize);
   tex->SetLineWidth(2);
   tex->Draw();

      tex = new TLatex(tex2x1,texy1,"MExtractBlindPixel:");
   tex->SetTextSize(texsize);
   tex->SetLineWidth(2);
   tex->Draw();
      tex = new TLatex(tex3x1,texy1,"MExtractPINDiode:");
   tex->SetTextSize(texsize);
   tex->SetLineWidth(2);
   tex->Draw();

   texy1 = 0.79;

      tex = new TLatex(tex1x1+0.02,texy1,"sum FADC slices, error??");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();

      tex = new TLatex(tex2x1+0.02,texy1,"sum FADC slices");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();
      tex = new TLatex(tex3x1+0.02,texy1,"sum FADC slices");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();


   arry1 = 0.89;
   arry2 = 0.84;

   TArrow *arrow = new TArrow(0.45, arry1,arr1x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

   arrow         = new TArrow(arr2x1,arry1,arr2x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

   arrow         = new TArrow(0.715, arry1,arr3x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   
// Third line:
   pty1 = 0.67;
   pty2 = 0.73;
   
   pt = new TPaveText(pt1x1,pty1,pt1x2,pty2,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MExtractedSignalCam");
   pt->Draw();
   
   pt = new TPaveText(pt2x1,pty1,pt2x2,pty2,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MExtractedSignalBlindPixel");
   pt->Draw();
   
   pt = new TPaveText(pt3x1,pty1,pt3x2,pty2,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MExtractedSignalPINDiode");
   pt->Draw();

   arry1 = 0.77;
   arry2 = 0.73;

   arrow = new TArrow(arr1x1,arry1,arr1x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr2x1,arry1,arr2x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr3x1,arry1,arr3x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();


// Fourth line:
   elly1 = 0.6;

   TEllipse *ellipse = new TEllipse(ell1x1,elly1,ellr1,ellr2,0,360,0);
   ellipse->Draw();
   
   ellipse = new TEllipse(ell2x1,elly1,ellr1,ellr2,0,360,0);
   ellipse->Draw();
   
   ellipse = new TEllipse(ell3x1,elly1,ellr1,ellr2,0,360,0);
   ellipse->Draw();

   texy1 = 0.6;

      tex = new TLatex(tex1x1,texy1,"MHCalibrationChargeCam:");
   tex->SetTextSize(texsize2);
   tex->SetLineWidth(2);
   tex->Draw();
      tex = new TLatex(tex2x1,texy1,"MHCalibrationChargeBlindPix:");
   tex->SetTextSize(texsize2);
   tex->SetLineWidth(2);
   tex->Draw();
      tex = new TLatex(tex3x1,texy1,"MHCalibrationChargePINDiode:");
   tex->SetTextSize(texsize2);
   tex->SetLineWidth(2);
   tex->Draw();

   texy1 = 0.585;

      tex = new TLatex(tex1x1+0.01,texy1,"Fit High-, Low-Gain, each pixel");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();

      tex = new TLatex(tex2x1+0.01,texy1,"Fit Single-Phe spectrum");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();
      tex = new TLatex(tex3x1+0.01,texy1,"Fit Charge distribution");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();




   arry1 = 0.67;
   arry2 = 0.63;

   arrow = new TArrow(arr1x1,arry1,arr1x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr2x1,arry1,arr2x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr3x1,arry1,arr3x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

// Fifth line:
   pty1 = 0.465;
   pty2 = 0.525;

   pt = new TPaveText(pt1x1,pty1-0.03,pt1x2,pty2,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MCalibrationChargeCam:");
   pt->Draw();
   text = pt->AddText("Conv. FADC to Phe's, error");
   text->SetTextColor(kBlue);
   pt->Draw();
   text = pt->AddText("Total F-Factor to Photons");
   text->SetTextColor(kBlue);
   pt->Draw();
   
   pt = new TPaveText(pt2x1,pty1,pt2x2,pty2,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MCalibrationChargeBlindPix");
   pt->Draw();
   
   pt = new TPaveText(pt3x1,pty1,pt3x2,pty2,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MCalibrationChargePINDiode");
   pt->Draw();
   

   arry1 = 0.565;
   arry2 = 0.525;

   arrow = new TArrow(arr1x1,arry1,arr1x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr2x1,arry1,arr2x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr3x1,arry1,arr3x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();


// Sixth line:
   Float_t nellx1 = 0.39;
   elly1 = 0.38;

   ellipse = new TEllipse(0.57,elly1,0.235,0.04,0,360,0);
   ellipse->Draw();

      tex = new TLatex(nellx1,0.38,"MCalibrationChargeCalc:");
   tex->SetTextSize(0.0328253);
   tex->SetLineWidth(2);
   tex->Draw();

   tex = new TLatex(nellx1+0.02,0.365,"Low Gain Ped., Red. #sigma's, Nr. Phe's, total F-Factor");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();

   tex = new TLatex(nellx1+0.02,0.355,"#gamma-fluxes: F-Factor, BlindPixel, PIN Diode Method");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();


   arry1 = 0.46;
   arry2 = 0.42;

   arrow = new TArrow(arr1x1,0.435,arr1x1+0.1,arry2-0.01,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr2x1,arry1,arr2x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr3x1,arry1,arr3x1-0.1,arry2-0.01,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

   Float_t linex1 = 0.135;
   Float_t liney1 = 0.38;

   TLine *line = new TLine(linex1,0.87,linex1,liney1);
   line->Draw();

   arrow = new TArrow(linex1,liney1,0.335544,liney1,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

   arrow = new TArrow(0.35,0.395,0.24,0.433,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

// seventh line
   pt = new TPaveText(0.3,0.215,0.85,0.29,"br");
   pt->SetFillColor(18);
   text = pt->AddText("MCalibrationQECam:");
   pt->Draw();
   text = pt->AddText("QE: Green, Blue, UV, CT1, av. Cascades(cos#theta), error");
   text->SetTextColor(kBlue);
   pt->Draw();
   text = pt->AddText("QE: F-Factor, Blind Pixel, PIN Diode, Combined Method");
   text->SetTextColor(kBlue);
   pt->Draw();
   

   arry1 = 0.34;
   arry2 = 0.3;

   arrow = new TArrow(arr1x1+0.1,arry1+0.01,arr1x1+0.1,arry2-0.01,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr2x1,arry1,arr2x1,arry2-0.01,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();
   arrow = new TArrow(arr3x1-0.1,arry1+0.01,arr3x1-0.1,arry2-0.01,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

// eightth line:

   Float_t nellx1 = 0.39;
   elly1 = 0.13;

   ellipse = new TEllipse(0.57,elly1,0.235,0.04,0,360,0);
   ellipse->Draw();

      tex = new TLatex(nellx1,elly1,"MCalibrate:");
   tex->SetTextSize(0.0328253);
   tex->SetLineWidth(2);
   tex->Draw();

   tex = new TLatex(nellx1+0.02,elly1-0.01,"Sum FADC slices to Phe's");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();

   tex = new TLatex(nellx1+0.02,elly1-0.02,"Phe's to photons (cos#theta), #Delta(photons)");
   tex->SetTextSize(texsize2);
   tex->SetTextColor(kRed);
   tex->SetLineWidth(1);
   tex->Draw();

   arry1 = 0.21;
   arry2 = 0.17;

   arrow = new TArrow(arr2x1,arry1,arr2x1,arry2,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

   Float_t linex1 = 0.215;
   Float_t liney1 = 0.13;

   TLine *line = new TLine(linex1,0.435,linex1,liney1);
   line->Draw();

   arrow = new TArrow(linex1,liney1,0.335544,liney1,arrsize,"|>");
   arrow->SetFillColor(1);
   arrow->SetFillStyle(1001);
   arrow->Draw();

   CalibClasses->Modified();
   CalibClasses->cd();

   CalibClasses->SaveAs("CalibClasses.gif");
}
