/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Robert Wagner  10/2002 <mailto:magicsoft@rwagner.de>
!
!   Copyright: MAGIC Software Development, 2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSigmabarParam                                                          //
//                                                                         //
// Storage Container for parameters characterizing a distribution of       //
// events in the Sigmabar-Theta plane                                      //
//                                                                         //
// For CT1 tests, we just store Sigmabar_max, Sigmabar_min, Theta_max,     //
// Theta_min. Later MJD and perhaps more than two points on the            //
// distribution might follow.                                              //
//                                                                         //
//  This implementation is still PRELIMINARY and requires some workarounds //
//  put in SPECIFICALLY FOR THE CT1 TESTS, since a database to access is   //
//  missing. It is not the FINAL MAGIC VERSION.                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MSigmabarParam.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MSigmabarParam);

using namespace std;

MSigmabarParam::MSigmabarParam(const char *name, const char *title) : fSigmabarMin(0), fSigmabarMax(0), fMjdMin(0), fMjdMax(0), fThetaMin(0), fThetaMax(0), fRunNumber(0)
{
    fName  = name  ? name  : "MSigmabarParam";
    fTitle = title ? title : "Storage container for characterizing a distribution of events in the Sigmabar-Theta plane";      
}

MSigmabarParam::~MSigmabarParam()
{
  // nothing special yet
}

void MSigmabarParam::SetRunNumber(Int_t r)
{
  fRunNumber = r;
}

void MSigmabarParam::SetParams(Int_t r, Double_t si, Double_t sx, Double_t ti, Double_t tx, Double_t mi, Double_t mx)
{
  fSigmabarMin = si;
  fSigmabarMax = sx;
  fThetaMin = ti;
  fThetaMax = tx;
  fMjdMin = mi;
  fMjdMax = mx;
  //fRunNumber = r;
}

void MSigmabarParam::Print(Option_t *) const
{
  *fLog << endl << "Run " << fRunNumber << " | " 
       << "Sigmabar Min, Max: " << fSigmabarMin << " " << fSigmabarMax 
       << "| Theta Min, Max: " << fThetaMin << " " << fThetaMax << endl;
}
