#ifndef MARS_MCalibrationChargeBlindPix
#define MARS_MCalibrationChargeBlindPix

#ifndef MARS_MCalibrationChargeCam
#include "MCalibrationChargeCam.h"
#endif

#ifndef MARS_MCalibrationChargePix
#include "MCalibrationChargePix.h"
#endif

class MCalibrationChargeBlindPix : public MCalibrationChargePix
{
private:

  static const Float_t gkBlindPixelArea;        //! The Blind Pixel area in mm^2
  static const Float_t gkBlindPixelAttGreen;    //! Attenuation Filter at 520 nm 
  static const Float_t gkBlindPixelAttBlue ;    //! Attenuation Filter at 460 nm 
  static const Float_t gkBlindPixelAttUV   ;    //! Attenuation Filter at 370 nm 
  static const Float_t gkBlindPixelAttCT1  ;    //! Attenuation Filter at 370 nm
  static const Float_t gkBlindPixelQEGreen;     //! Quantum Efficiency at 520 nm
  static const Float_t gkBlindPixelQEBlue ;     //! Quantum Efficiency at 460 nm
  static const Float_t gkBlindPixelQEUV   ;     //! Quantum Efficiency at 370 nm
  static const Float_t gkBlindPixelQECT1  ;     //! Quantum Efficiency at 370 nm
  static const Float_t gkBlindPixelQEGreenErr;  //! Uncertainty QE at 520 nm 
  static const Float_t gkBlindPixelQEBlueErr ;  //! Uncertainty QE at 460 nm 
  static const Float_t gkBlindPixelQEUVErr   ;  //! Uncertainty QE at 370 nm 
  static const Float_t gkBlindPixelQECT1Err  ;  //! Uncertainty QE at 370 nmu

  Float_t fLambda;                  // Mean Poisson fit
  Float_t fLambdaCheck;             // Mean Pedestal Check (Gauss) fit
  Float_t fLambdaCheckErr;          // Error mean pedestal Check fit
  Float_t fLambdaVar;               // Variance lambda Poisson fit
  Float_t fFluxInsidePlexiglass;    // Number photons in INNER PIXEL inside the plexiglass
  Float_t fFluxInsidePlexiglassVar; // Variance number of photons in INNER PIXEL 
  Float_t fMu0;                     // Position pedestal peak
  Float_t fMu0Err;                  // Error pos. pedestal-peak
  Float_t fMu1;                     // Position first photo-electron peak
  Float_t fMu1Err;                  // Error pos. first photo-electon peak
  Float_t fSigma0;                  // Width pedestal peak
  Float_t fSigma0Err;               // Error width pedestal peak
  Float_t fSigma1;                  // Width first photo-electron peak  
  Float_t fSigma1Err;               // Error width first photo-electron peak  

  enum { kOscillating, kPedestalFitOK, kSinglePheFitOK, kChargeFitValid, 
         kFluxInsidePlexiglassAvailable };

  MCalibrationCam::PulserColor_t fColor;  

  const Float_t GetBlindPixelQEGreenRelVar() const; 
  const Float_t GetBlindPixelQEBlueRelVar () const; 
  const Float_t GetBlindPixelQEUVRelVar   () const; 
  const Float_t GetBlindPixelQECT1RelVar  () const; 

 public:

  MCalibrationChargeBlindPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationChargeBlindPix() {}
  
  Bool_t CalcFluxInsidePlexiglass();
  void   Clear(Option_t *o="");
  
  // Getters
  MCalibrationCam::PulserColor_t GetColor () const { return fColor;                }
  Float_t GetLambda                       () const { return fLambda;               }
  Float_t GetLambdaErr                    () const;
  Float_t GetLambdaRelVar                 () const;  
  Float_t GetLambdaCheck                  () const { return fLambdaCheck;          }
  Float_t GetLambdaCheckErr               () const { return fLambdaCheckErr;       }
  Float_t GetFluxInsidePlexiglass         () const { return fFluxInsidePlexiglass; }
  Float_t GetFluxInsidePlexiglassErr      () const;
  Float_t GetFluxInsidePlexiglassRelVar   () const;  
  Float_t GetMu0                          () const { return fMu0;                  }
  Float_t GetMu0Err                       () const { return fMu0Err;               }
  Float_t GetMu1                          () const { return fMu1;                  }
  Float_t GetMu1Err                       () const { return fMu1Err;               }
  Float_t GetSigma0                       () const { return fSigma0;               }
  Float_t GetSigma0Err                    () const { return fSigma0Err;            } 
  Float_t GetSigma1                       () const { return fSigma1;               }
  Float_t GetSigma1Err                    () const { return fSigma1Err;            }

  Bool_t  IsOscillating                   () const;
  Bool_t  IsChargeFitValid                () const;
  Bool_t  IsPedestalFitOK                 () const;
  Bool_t  IsSinglePheFitOK                () const;
  Bool_t  IsFluxInsidePlexiglassAvailable () const;
  
  // Setters
  void SetColor          ( const MCalibrationCam::PulserColor_t color ) { fColor      = color; }
  void SetLambda         ( const Float_t f )                            { fLambda         = f; }
  void SetLambdaVar      ( const Float_t f )                            { fLambdaVar      = f; }
  void SetLambdaCheck    ( const Float_t f )                            { fLambdaCheck    = f; }
  void SetLambdaCheckErr ( const Float_t f )                            { fLambdaCheckErr = f; }
  void SetMu0            ( const Float_t f )                            { fMu0            = f; }
  void SetMu0Err         ( const Float_t f )                            { fMu0Err         = f; }
  void SetMu1            ( const Float_t f )                            { fMu1            = f; }
  void SetMu1Err         ( const Float_t f )                            { fMu1Err         = f; }
  void SetSigma0         ( const Float_t f )                            { fSigma0         = f; }
  void SetSigma0Err      ( const Float_t f )                            { fSigma0Err      = f; }
  void SetSigma1         ( const Float_t f )                            { fSigma1         = f; }
  void SetSigma1Err      ( const Float_t f )                            { fSigma1Err      = f; }

  void SetOscillating    ( const Bool_t  b=kTRUE );
  void SetChargeFitValid ( const Bool_t  b=kTRUE );
  void SetPedestalFitOK  ( const Bool_t  b=kTRUE );
  void SetSinglePheFitOK ( const Bool_t  b=kTRUE );
  void SetFluxInsidePlexiglassAvailable( const Bool_t b=kTRUE);

  ClassDef(MCalibrationChargeBlindPix, 1)	// Container Charge Calibration Results Blind Pixel
};

#endif




