#ifndef MARS_MHAlpha
#define MARS_MHAlpha

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MParList;
class MParameterD;
class MHMatrix;

class MHAlpha : public MH
{
private:
    Float_t fAlphaCut;        // Alpha cut
    Float_t fBgMean;          // Background mean

    Float_t fSigInt;
    Float_t fSigMax;
    Float_t fBgMin;
    Float_t fBgMax;
    Int_t   fPolynom;

    TH1D    fHist;            // Alpha vs. x and y

    MParameterD *fResult;

    MHMatrix *fMatrix;        //!
    Int_t fMap;               //!

public:
    MHAlpha(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pl);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    void Paint(Option_t *opt="");
    void Draw(Option_t *option="");

    void InitMapping(MHMatrix *mat);
    void StopMapping();

    static Double_t Significance(Double_t s, Double_t b);

    ClassDef(MHAlpha, 1) //3D-histogram in alpha, x and y
};

#endif
