#ifndef MARS_MHAlphaEnergyTime
#define MARS_MHAlphaEnergyTime

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include "TH3.h"
#endif

#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MHillasSrc;
class MEnergyEst;
class MTime;
class TH2D;
class MParList;

class MHAlphaEnergyTime : public MH
{
private:
    MHillasSrc *fHillas; //!
    MEnergyEst *fEnergy; //!
    MTime      *fTime;   //!

    TH3D    fHist;

public:
    MHAlphaEnergyTime(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);

    const TH3D *GetHist()       { return &fHist; }
    const TH3D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");

    TH2D *IntegrateTime    (const char *title, Bool_t Draw);
    TH2D *IntegrateEest    (const char *title, Bool_t Draw);
    TH1D *IntegrateEestTime(const char *title, Bool_t Draw);
   
    ClassDef(MHAlphaEnergyTime, 0) //3D-histogram in alpha, Energy and time
};

#endif






