#ifndef MARS_MExtractPINDiode
#define MARS_MExtractPINDiode

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MExtractPINDiode                                                        //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MRawRunHeader;

class MPedestalCam;
class MExtractedSignalPINDiode;
class MExtractPINDiode : public MTask
{
private:

  static const UInt_t fgPINDiodeIdx;  
  static const Byte_t fgSaturationLimit;
  static const Byte_t fgFirst;
  static const Byte_t fgLast;

  MPedestalCam              *fPedestals;    // Pedestals of all pixels in the camera
  MExtractedSignalPINDiode  *fPINDiode;     // Extracted signal of the PIN Diode

  MRawEvtData         *fRawEvt;       // raw event data (time slices)
  MRawRunHeader       *fRunHeader;    // RunHeader information
  
  Byte_t  fFirst;
  Byte_t  fLast;
  Byte_t  fNumSamples;
  Float_t fSqrtSamples;
  Byte_t  fSaturationLimit;
  UInt_t  fPINDiodeIdx;

  Float_t fPedestal;
  Float_t fPedRms;
  
  void   FindSignal(Byte_t *ptr, Int_t size, UInt_t &sum, UInt_t &sum2, UInt_t &sat, UInt_t &max) const;
  
  Int_t  PreProcess(MParList *pList);
  Int_t  Process();
  void   StreamPrimitive(ofstream &out) const;
  
public:

  MExtractPINDiode(const char *name=NULL, const char *title=NULL);

  // Setters
  void SetRange(const Byte_t hifirst=fgFirst, 
                const Byte_t hilast=fgLast);
  void SetSaturationLimit(const Byte_t lim=fgSaturationLimit) { fSaturationLimit = lim; }
  void SetPINDiodeIdx(    const UInt_t idx=fgPINDiodeIdx    ) { fPINDiodeIdx     = idx; }   

  ClassDef(MExtractPINDiode, 0) // Task to fill the Extracted PINDiode Containers from raw data
};

#endif
