#ifndef MARS_MPointingPos
#define MARS_MPointingPos

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MTime;
class MObservatory;

class MPointingPos : public MParContainer
{
private:
    Double_t fZd;  // [deg] Zenith distance (ZA)
    Double_t fAz;  // [deg] Azimuth

    Double_t fRa;  // [h]   Right ascension
    Double_t fHa;  // [h]   Hour angle
    Double_t fDec; // [deg] Declination

public:
    MPointingPos(const char *name=0, const char *title=0)
    {
        fName  = name ? name   : "MPointingPos";
        fTitle = title ? title : "Container storing the (corrected) telescope pointing position";
    }

    void SetLocalPosition(Double_t zd, Double_t az) { fZd=zd; fAz=az; }
    void SetSkyPosition(Double_t ra, Double_t dec, Double_t ha=0) { fRa=ra; fDec=dec; fHa=ha; }

    Double_t GetZd() const  { return fZd; }
    Double_t GetAz() const  { return fAz; }

    Double_t GetRa() const  { return fRa; }
    Double_t GetDec() const { return fDec; }

    Double_t GetRaRad() const  { return fRa*TMath::DegToRad()*15; }
    Double_t GetDecRad() const { return fDec*TMath::DegToRad(); }

    Double_t RotationAngle(const MObservatory &o) const;
    Double_t RotationAngle(const MObservatory &o, const MTime &t) const;
    Double_t RotationAngle(const MObservatory &o, const MTime *t) const
    {
        return t ? RotationAngle(o, *t) : RotationAngle(o);
    }

    ClassDef(MPointingPos, 1) //Container storing the (corrected) telescope pointing position
};

#endif
