#ifndef MARS_MCalibrate
#define MARS_MCalibrate

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrate                                                              //
//                                                                         //
// Integrates the desired ADC time slices of one pixel and apply           //
// calibration constants                                                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MBadPixelsCam;
class MCalibrationChargeCam;
class MCalibrationQECam;
class MExtractedSignalCam;
class MCerPhotEvt;

class MCalibrate : public MTask
{
private:
    MGeomCam              *fGeomCam;      // Camera geometry container
    MCalibrationChargeCam *fCalibrations; // Calibration constants
    MCalibrationQECam     *fQEs;          // Quantum efficiencies
    MBadPixelsCam         *fBadPixels;    // Bad Pixels information
    MExtractedSignalCam   *fSignals;      // Integrated charge in FADCs counts
    MCerPhotEvt           *fCerPhotEvt;   // Cerenkov Photon Event used for calculation

    Float_t fConversionHiLo;
    UShort_t fCalibrationMode;
    
    Int_t PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Int_t Process();

public:

    enum CalibrationMode_t{kNone=0,kFlatCharge=1,kBlindPixel,kFfactor,kPinDiode,kCombined, kDummy};
    static const CalibrationMode_t kDefault = kBlindPixel;

    MCalibrate(CalibrationMode_t calmode = kDefault,const char *name=NULL, const char *title=NULL);

    void SetConversionHiLo(Float_t conv) { fConversionHiLo = conv; };
    void SetCalibrationMode(CalibrationMode_t calmode=kDefault){ fCalibrationMode=calmode;};
    
    ClassDef(MCalibrate, 0)   // Task to calculate cerenkov photons using calibration constants
};
 

#endif
