#ifndef MARS_MGCamDisplays
#define MARS_MGCamDisplays

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

class TCanvas;
class MHCamera;
class MCamEvent;
class MGCamDisplays
{
protected:

  void DrawProjection   ( MHCamera *obj, Int_t fit) const;     // Draw projection of pixels values
  void DrawRadialProfile( MHCamera *obj)            const;      // Draw projection of pixels values onto camera radius
  void CamDraw(TCanvas &c, const Int_t x, const Int_t y, const MHCamera &cam1,
               const Int_t fit, const Int_t rad=0,
               TObject *notify=NULL);                    // Draw histograms into the MStatusDisplay

public:
  
  MGCamDisplays();
  
  ClassDef(MGCamDisplays, 0) // Tools to display the camera in an MStatusDisplay
};

#endif
